/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.console;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.statet.ecommons.runtime.core.util.StatusUtils;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.string.MStringAUtils;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.ui.NicoUIMessages;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.nico.ui.console.NIConsolePage;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.actions.ActionFactory;

class SubmitPasteAction
extends Action {
    private final NIConsolePage view;

    public SubmitPasteAction(NIConsolePage consolePage) {
        super(NicoUIMessages.PasteSubmitAction_name);
        this.setId(ActionFactory.PASTE.getId());
        this.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.view = consolePage;
    }

    public void run() {
        TextTransfer transfer = TextTransfer.getInstance();
        String text = (String)this.view.getClipboard().getContents((Transfer)transfer);
        ToolController controller = this.view.getConsole().getProcess().getController();
        if (text == null || controller == null) {
            return;
        }
        NicoUITools.runSubmitInBackground(controller.getTool(), SubmitPasteAction.createRunnable(controller, text), this.view.getSite().getShell());
    }

    static IRunnableWithProgress createRunnable(final ToolController controller, final String text) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor);
                try {
                    try {
                        m.beginTask(NicoUITools.createSubmitMessage(controller.getTool()), 10);
                        List lines = MStringAUtils.linesToList((String)text);
                        m.worked(2);
                        Status status = controller.submit(lines, SubmitType.CONSOLE, (IProgressMonitor)m.newChild(8));
                        if (status.getSeverity() >= 4) {
                            throw new CoreException(StatusUtils.convert((Status)status));
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    m.done();
                }
            }
        };
    }
}

