/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.console;

import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.statet.ecommons.ui.util.DNDUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.swt.EnhStyledText;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

@NonNullByDefault
public class InputSourceViewer
extends SourceViewer {
    InputSourceViewer(Composite parent) {
        super(parent, null, null, false, 4);
        this.initializeDragAndDrop();
        this.initTabControl();
    }

    protected StyledText createTextWidget(Composite parent, int styles) {
        return EnhStyledText.forSourceEditor((Composite)parent, (int)styles);
    }

    protected void initializeDragAndDrop() {
        DNDUtils.addDropSupport((Control)this.getTextWidget(), (DropTargetListener)new DNDUtils.SimpleTextDropAdapter(){

            protected StyledText getTextWidget() {
                return InputSourceViewer.this.getTextWidget();
            }
        }, (Transfer[])new Transfer[]{TextTransfer.getInstance()});
    }

    private void initTabControl() {
        this.getTextWidget().addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.stateMask == 0 && event.character == '\t') {
                    event.doit = false;
                }
            }
        });
    }

    protected void clear() {
        IContentAssistant iContentAssistant = this.fContentAssistant;
        if (iContentAssistant instanceof ContentAssist) {
            ContentAssist assist = (ContentAssist)iContentAssistant;
            assist.hidePopups();
        }
        this.getDocument().set("");
    }
}

