/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.refactoring;

import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.statet.ltk.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.swt.widgets.Shell;

public class RefactoringWizardExecutionHelper {
    private final RefactoringWizard wizard;
    private final int saveMode;
    private final boolean build;
    private RefactoringStatus status;

    public RefactoringWizardExecutionHelper(RefactoringWizard wizard, int saveMode) {
        this(wizard, saveMode, false);
    }

    public RefactoringWizardExecutionHelper(RefactoringWizard wizard, int saveMode, boolean build) {
        this.wizard = wizard;
        this.saveMode = saveMode;
        this.build = build;
    }

    public boolean perform(Shell parent) {
        RefactoringSaveHelper saveHelper = new RefactoringSaveHelper(this.saveMode);
        if (!saveHelper.saveEditors(parent) && (this.saveMode & 0x100) == 0) {
            return false;
        }
        try {
            if (this.build) {
                saveHelper.triggerBuild();
            }
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation(this.wizard);
            int result = op.run(parent, this.wizard.getRefactoring().getName());
            this.status = op.getInitialConditionCheckingStatus();
            return result != 1 && result != 1025;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public RefactoringStatus getInitialConditionCheckingStatus() {
        return this.status;
    }
}

