/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.workbench.texteditor;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.texteditor.IUpdate;

@NonNullByDefault
public class ActionHandler
extends AbstractHandler {
    private final IAction action;
    private boolean isDisposed;
    private @Nullable IPropertyChangeListener propertyChangeListener;

    public ActionHandler(IAction action) {
        this.action = action;
    }

    public void dispose() {
        this.isDisposed = true;
        this.detachListener();
        super.dispose();
    }

    public final IAction getAction() {
        return this.action;
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
        if (this.isDisposed) {
            return;
        }
        if (!this.hasListeners()) {
            this.attachListener();
        }
        super.addHandlerListener(handlerListener);
    }

    private void attachListener() {
        if (this.propertyChangeListener == null) {
            IPropertyChangeListener listener;
            this.propertyChangeListener = listener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    ActionHandler.this.fireHandlerChanged(new HandlerEvent((IHandler)ActionHandler.this, "enabled".equals(property), "handled".equals(property)));
                }
            };
        }
        this.action.addPropertyChangeListener(this.propertyChangeListener);
    }

    private void detachListener() {
        IPropertyChangeListener listener = this.propertyChangeListener;
        if (listener != null) {
            this.propertyChangeListener = null;
            this.action.removePropertyChangeListener(listener);
        }
    }

    public void setEnabled(@Nullable Object evaluationContext) {
        if (this.action instanceof IUpdate) {
            ((IUpdate)this.action).update();
        }
        this.setBaseEnabled(this.action.isEnabled());
    }

    public final @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.action.getStyle() == 2 || this.action.getStyle() == 8) {
            this.action.setChecked(!this.action.isChecked());
        }
        try {
            Object trigger = event.getTrigger();
            Event swtEvent = trigger instanceof Event ? (Event)trigger : new Event();
            this.action.runWithEvent(swtEvent);
            return null;
        }
        catch (Exception e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isHandled() {
        return this.action.isHandled();
    }

    public boolean isEnabled() {
        return this.action.isEnabled();
    }

    public final String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder(ActionHandler.class);
        sb.append(' ', this.action.toString());
        return sb.toString();
    }
}

