/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.text.core;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.statet.ecommons.text.core.PartitionConstraint;
import org.eclipse.statet.ecommons.text.core.TextTokenScanner;
import org.eclipse.statet.ecommons.text.core.util.TextUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.string.CharPair;
import org.eclipse.statet.jcommons.text.core.CharPairSet;
import org.eclipse.statet.ltk.text.core.CharPairMatcher;
import org.eclipse.statet.ltk.text.core.HeuristicTokenScanner;

@NonNullByDefault
public class BasicCharPairMatcher
implements CharPairMatcher {
    private static final char IGNORE = '\n';
    private static final byte NOTHING_FOUND = 0;
    private static final byte OPENING_NOT_FOUND = 1;
    private static final byte CLOSING_NOT_FOUND = 2;
    private static final byte PAIR_FOUND = 3;
    protected final CharPairSet pairs;
    protected final String partitioning;
    protected final PartitionConstraint partitionConstraint;
    protected final TextTokenScanner scanner;
    protected int offset;
    protected int beginPos;
    protected int endPos;
    protected int anchor;
    protected @Nullable ITypedRegion partition;

    public BasicCharPairMatcher(CharPairSet pairs, String partitioning, PartitionConstraint partitionConstraint, TextTokenScanner scanner) {
        this.pairs = pairs;
        this.scanner = scanner;
        this.partitioning = partitioning;
        this.partitionConstraint = partitionConstraint;
    }

    public BasicCharPairMatcher(HeuristicTokenScanner scanner) {
        this.pairs = scanner.getDefaultBrackets();
        this.scanner = scanner;
        this.partitioning = scanner.getDocumentPartitioning();
        this.partitionConstraint = scanner.getDefaultPartitionConstraint();
    }

    @Override
    public @Nullable IRegion match(IDocument document, int offset) {
        if (document == null || offset < 0) {
            return null;
        }
        this.offset = offset;
        if (this.matchPairsAt(document, true) == 3) {
            return new Region(this.beginPos, this.endPos - this.beginPos + 1);
        }
        return null;
    }

    @Override
    public @Nullable IRegion match(IDocument document, int offset, boolean auto) {
        if (document == null || offset < 0) {
            return null;
        }
        this.offset = offset;
        switch (this.matchPairsAt(document, auto)) {
            case 1: {
                return new Region(this.endPos, -1);
            }
            case 2: {
                return new Region(this.beginPos, -1);
            }
            case 3: {
                return new Region(this.beginPos, this.endPos - this.beginPos + 1);
            }
        }
        return null;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void dispose() {
        this.clear();
    }

    public void clear() {
    }

    protected byte matchPairsAt(IDocument document, boolean auto) {
        this.beginPos = -1;
        this.endPos = -1;
        try {
            ITypedRegion prevPartition;
            int thisChar = 10;
            ITypedRegion thisPartition = this.getPartition(document, this.offset);
            if (thisPartition != null && this.offset < document.getLength()) {
                thisChar = document.getChar(this.offset);
            }
            char prevChar = '\n';
            if (this.offset > 0) {
                prevPartition = this.getPartition(document, this.offset - 1);
                if (prevPartition != null && auto) {
                    prevChar = document.getChar(this.offset - 1);
                    if (this.pairs.getEscapeChar() > '\u0000') {
                        int partitionOffset = prevPartition.getOffset();
                        int checkOffset = this.offset - 2;
                        while (checkOffset >= partitionOffset) {
                            if (document.getChar(checkOffset) != this.pairs.getEscapeChar()) break;
                            --checkOffset;
                        }
                        if ((this.offset - checkOffset) % 2 == 1) {
                            prevChar = '\n';
                        } else if (prevPartition.equals(thisPartition) && prevChar == this.pairs.getEscapeChar()) {
                            thisChar = 10;
                        }
                    }
                }
            } else {
                prevPartition = null;
            }
            CharPairSet.CharMatch match = this.findChar(prevChar, prevPartition, (char)thisChar, thisPartition);
            if (this.beginPos > -1) {
                this.anchor = 1;
                this.endPos = this.findClosingPeer(document, this.partition, this.beginPos + 1, match.getPair());
                return (byte)(this.endPos > -1 && this.beginPos != this.endPos ? 3 : 2);
            }
            if (this.endPos > -1) {
                this.anchor = 0;
                this.beginPos = this.findOpeningPeer(document, this.partition, this.endPos, match.getPair());
                return (byte)(this.beginPos > -1 && this.beginPos != this.endPos ? 3 : 1);
            }
        }
        catch (BadLocationException | BadPartitioningException throwable) {
            // empty catch block
        }
        return 0;
    }

    private @Nullable ITypedRegion getPartition(IDocument document, int offset) throws BadPartitioningException, BadLocationException {
        ITypedRegion partition = TextUtils.getPartition((IDocument)document, (String)this.partitioning, (int)offset, (boolean)false);
        return this.partitionConstraint.matches(partition.getType()) ? partition : null;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable CharPairSet.CharMatch findChar(char prevChar, ITypedRegion prevPartition, char thisChar, ITypedRegion thisPartition) {
        CharPairSet.CharMatch thisMatch = this.pairs.getMatch((int)thisChar);
        if (thisMatch != null && thisMatch.isClosing()) {
            this.endPos = this.offset;
            this.partition = thisPartition;
            return thisMatch;
        }
        CharPairSet.CharMatch prevMatch = this.pairs.getMatch((int)prevChar);
        if (prevMatch != null && prevMatch.isOpening()) {
            this.beginPos = this.offset - 1;
            this.partition = prevPartition;
            return prevMatch;
        }
        if (thisMatch != null) {
            this.beginPos = this.offset;
            this.partition = thisPartition;
            return thisMatch;
        }
        if (prevMatch != null) {
            this.endPos = this.offset - 1;
            this.partition = prevPartition;
            return prevMatch;
        }
        this.partition = null;
        return null;
    }

    protected int findClosingPeer(IDocument document, ITypedRegion partition, int start, CharPair pair) throws BadLocationException {
        this.scanner.configure(document, partition.getType());
        return this.scanner.findClosingPeer(start, pair, this.pairs.getEscapeChar());
    }

    protected int findOpeningPeer(IDocument document, ITypedRegion partition, int start, CharPair pair) throws BadLocationException {
        this.scanner.configure(document, partition.getType());
        return this.scanner.findOpeningPeer(start, pair, this.pairs.getEscapeChar());
    }
}

