/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.refactoring.core;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.refactoring.core.SourceUnitChange;

public class TextChangeManager {
    private final Map<SourceUnit, TextFileChange> map = new HashMap<SourceUnit, TextFileChange>(10);
    private final boolean keepExecutedTextEdits;

    public TextChangeManager() {
        this(false);
    }

    public TextChangeManager(boolean keepExecutedTextEdits) {
        this.keepExecutedTextEdits = keepExecutedTextEdits;
    }

    public TextFileChange get(SourceUnit su) {
        TextFileChange result = this.map.get(su);
        if (result == null) {
            result = new SourceUnitChange(su);
            result.setKeepPreviewEdits(this.keepExecutedTextEdits);
            this.map.put(su, result);
        }
        return result;
    }

    public TextChange remove(SourceUnit unit) {
        return (TextChange)this.map.remove(unit);
    }

    public SourceUnit[] getAllSourceUnits() {
        return this.map.keySet().toArray(new SourceUnit[this.map.keySet().size()]);
    }

    public TextChange[] getAllChanges() {
        Set<SourceUnit> suSet = this.map.keySet();
        SourceUnit[] sus = suSet.toArray(new SourceUnit[suSet.size()]);
        Arrays.sort(sus, new Comparator<SourceUnit>(){

            @Override
            public int compare(SourceUnit su1, SourceUnit su2) {
                return su1.getId().compareTo(su2.getId());
            }
        });
        TextChange[] textChanges = new TextChange[sus.length];
        int i = 0;
        while (i < sus.length) {
            textChanges[i] = (TextChange)this.map.get(sus[i]);
            ++i;
        }
        return textChanges;
    }

    public boolean containsChangesIn(SourceUnit su) {
        return this.map.containsKey(su);
    }

    public void clear() {
        this.map.clear();
    }
}

