/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.refactoring.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteProcessor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.ltk.refactoring.core.Messages;
import org.eclipse.statet.ltk.model.core.ElementSet;
import org.eclipse.statet.ltk.refactoring.core.CommonRefactoringDescriptor;
import org.eclipse.statet.ltk.refactoring.core.DynamicValidationRefactoringChange;
import org.eclipse.statet.ltk.refactoring.core.RefactoringAdapter;
import org.eclipse.statet.ltk.refactoring.core.RefactoringMessages;
import org.eclipse.statet.ltk.refactoring.core.TextChangeManager;

public abstract class CommonDeleteProcessor
extends DeleteProcessor {
    private final RefactoringAdapter adapter;
    private final ElementSet elementsToDelete;
    private Change deleteChange;

    public CommonDeleteProcessor(ElementSet elements, RefactoringAdapter adapter) {
        assert (elements != null);
        assert (adapter != null);
        this.elementsToDelete = elements;
        this.adapter = adapter;
    }

    public abstract String getIdentifier();

    protected abstract String getRefactoringIdentifier();

    public String getProcessorName() {
        return Messages.DeleteRefactoring_label;
    }

    public Object[] getElements() {
        return this.elementsToDelete.getInitialObjects().toArray();
    }

    public Change getDeleteChange() {
        return this.deleteChange;
    }

    public boolean isApplicable() throws CoreException {
        return this.adapter.canDelete(this.elementsToDelete);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        this.adapter.checkInitialToModify(result, this.elementsToDelete);
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringMessages.Common_FinalCheck_label, (int)12);
        try {
            RefactoringStatus result = new RefactoringStatus();
            this.recalculateElementsToDelete();
            this.elementsToDelete.postProcess();
            this.adapter.checkFinalToDelete(result, this.elementsToDelete);
            m.worked(1);
            TextChangeManager textManager = new TextChangeManager();
            this.deleteChange = this.adapter.createChangeToDelete(this.getProcessorName(), this.elementsToDelete, textManager, (IProgressMonitor)m.newChild(10));
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            this.adapter.buildDeltaToDelete(this.elementsToDelete, deltaFactory);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        finally {
            m.done();
        }
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        ArrayList<RefactoringParticipant> result = new ArrayList<RefactoringParticipant>();
        this.adapter.addParticipantsToDelete(this.elementsToDelete, result, status, (RefactoringProcessor)this, shared);
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    protected void recalculateElementsToDelete() throws CoreException {
        this.elementsToDelete.removeElementsWithAncestorsOnList();
        this.adapter.confirmDeleteOfReadOnlyElements(this.elementsToDelete, null);
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(RefactoringMessages.Common_CreateChanges_label, 1);
            HashMap<String, String> arguments = new HashMap<String, String>();
            String description = this.elementsToDelete.getElementCount() == 1 ? Messages.DeleteRefactoring_description_singular : Messages.DeleteRefactoring_description_plural;
            IProject resource = this.elementsToDelete.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String source = project != null ? NLS.bind((String)RefactoringMessages.Common_Source_Project_label, (Object)project) : RefactoringMessages.Common_Source_Workspace_label;
            boolean flags = false;
            String comment = "";
            CommonRefactoringDescriptor descriptor = new CommonRefactoringDescriptor(this.getIdentifier(), project, description, "", arguments, 0);
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange(descriptor, Messages.DeleteRefactoring_label, new Change[]{this.deleteChange}, null);
            return dynamicValidationRefactoringChange;
        }
        finally {
            monitor.done();
        }
    }
}

