/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.util;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.SourceElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;

@NonNullByDefault
public class LtkModelElementComparator
implements Comparator<LtkModelElement> {
    private final Collator unitIdComparator = Collator.getInstance();
    private final Collator elementIdComparator;

    public LtkModelElementComparator() {
        this(Collator.getInstance());
    }

    public LtkModelElementComparator(Collator elementIdComparator) {
        this.elementIdComparator = elementIdComparator;
    }

    @Override
    public int compare(@Nullable LtkModelElement e1, @Nullable LtkModelElement e2) {
        SourceUnit u2;
        if (e1 == e2) {
            return 0;
        }
        if (e1 == null) {
            return 1;
        }
        if (e2 == null) {
            return -1;
        }
        SourceUnit u1 = LtkModelUtils.getSourceUnit(e1);
        int result = this.compareSourceUnits(u1, u2 = LtkModelUtils.getSourceUnit(e2));
        if (result != 0) {
            return result;
        }
        if (e1 instanceof SourceElement) {
            if (e2 instanceof SourceElement) {
                return this.compareSourceElementsInUnit((SourceElement)e1, (SourceElement)e2);
            }
            return -1;
        }
        if (e2 instanceof SourceElement) {
            return 1;
        }
        return this.elementIdComparator.compare(e1.getId(), e2.getId());
    }

    protected int compareSourceUnits(@Nullable SourceUnit u1, @Nullable SourceUnit u2) {
        if (u1 == u2) {
            return 0;
        }
        if (u1 == null) {
            return 1;
        }
        if (u2 == null) {
            return -1;
        }
        return this.unitIdComparator.compare(u1.getId(), u2.getId());
    }

    protected int compareSourceElementsInUnit(SourceElement e1, SourceElement e2) {
        return e1.getSourceRange().getStartOffset() - e2.getSourceRange().getStartOffset();
    }
}

