/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.impl;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.core.input.SourceFragment;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.model.core.element.SourceDocumentRunnable;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;

@NonNullByDefault
public abstract class GenericFragmentSourceUnit
implements SourceUnit {
    private final ElementName name = new ElementName(){

        @Override
        public int getType() {
            return 17;
        }

        @Override
        public String getDisplayName() {
            return GenericFragmentSourceUnit.this.fragment.getName();
        }

        @Override
        public String getSegmentName() {
            return GenericFragmentSourceUnit.this.fragment.getName();
        }

        @Override
        public @Nullable ElementName getNextSegment() {
            return null;
        }
    };
    private final SourceFragment fragment;
    private final long timestamp;
    private @Nullable AbstractDocument document;
    private int counter = 0;

    public GenericFragmentSourceUnit(String id, SourceFragment fragment) {
        this.fragment = (SourceFragment)ObjectUtils.nonNullAssert((Object)fragment);
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public @Nullable SourceUnit getUnderlyingUnit() {
        return null;
    }

    @Override
    public boolean isSynchronized() {
        return true;
    }

    @Override
    public String getId() {
        return this.fragment.getId();
    }

    public SourceFragment getFragment() {
        return this.fragment;
    }

    @Override
    public int getElementType() {
        return 640;
    }

    @Override
    public ElementName getElementName() {
        return this.name;
    }

    @Override
    public boolean exists() {
        return this.counter > 0;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean checkState(boolean validate, IProgressMonitor monitor) {
        return false;
    }

    @Override
    public @Nullable Object getResource() {
        return null;
    }

    @Override
    public synchronized AbstractDocument getDocument(@Nullable IProgressMonitor monitor) {
        AbstractDocument document = this.document;
        if (document == null) {
            this.document = document = this.fragment.getDocument();
        }
        return document;
    }

    @Override
    public long getContentStamp(@Nullable IProgressMonitor monitor) {
        return this.timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SourceContent getContent(IProgressMonitor monitor) {
        AbstractDocument document = this.getDocument(monitor);
        Object lockObject = null;
        if (document instanceof ISynchronizable) {
            lockObject = ((ISynchronizable)document).getLockObject();
        }
        if (lockObject == null) {
            lockObject = this.fragment;
        }
        Object object = lockObject;
        synchronized (object) {
            return new SourceContent(document.getModificationStamp(), document.get());
        }
    }

    @Override
    public void syncExec(SourceDocumentRunnable runnable) throws InvocationTargetException {
        runnable.run();
    }

    @Override
    public @Nullable AstInfo getAstInfo(@Nullable String type, boolean ensureSync, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public @Nullable SourceUnitModelInfo getModelInfo(@Nullable String type, int syncLevel, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public final synchronized void connect(IProgressMonitor monitor) {
        ++this.counter;
        if (this.counter == 1) {
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            this.register();
        }
    }

    @Override
    public final synchronized void disconnect(IProgressMonitor monitor) {
        --this.counter;
        if (this.counter == 0) {
            this.unregister();
        }
    }

    @Override
    public synchronized boolean isConnected() {
        return this.counter > 0;
    }

    protected void register() {
    }

    protected void unregister() {
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == SourceFragment.class) {
            return (T)this.fragment;
        }
        return null;
    }

    public String toString() {
        return this.getModelTypeId() + "/" + String.valueOf(this.getWorkingContext()) + ": " + this.getId();
    }
}

