/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.impl;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.core.WorkingContext;
import org.eclipse.statet.ltk.model.core.ElementChangedListener;
import org.eclipse.statet.ltk.model.core.LtkModels;
import org.eclipse.statet.ltk.model.core.ModelManager;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;

@NonNullByDefault
public abstract class AbstractModelManager
implements ModelManager {
    private static final ImIdentityList<ElementChangedListener> NO_LISTENERS = ImCollections.emptyIdentityList();
    private final String typeId;
    private final CopyOnWriteIdentityListSet<ContextItem> contexts = new CopyOnWriteIdentityListSet();

    public AbstractModelManager(String typeId) {
        this.typeId = typeId;
        for (WorkingContext context : this.getInitialContexts()) {
            this.getContextItemCreate(context);
        }
    }

    protected ImSet<WorkingContext> getInitialContexts() {
        return ImCollections.newIdentitySet((Object[])new WorkingContext[]{Ltk.PERSISTENCE_CONTEXT, Ltk.EDITOR_CONTEXT});
    }

    public String getModelTypeId() {
        return this.typeId;
    }

    protected @Nullable ContextItem getContextItem(WorkingContext context) {
        ImIdentityList contextItems = this.contexts.toList();
        for (ContextItem contextItem : contextItems) {
            if (contextItem.context != context) continue;
            return contextItem;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContextItem getContextItemCreate(WorkingContext context) {
        while (true) {
            ImIdentityList contextItems = this.contexts.toList();
            for (ContextItem contextItem : contextItems) {
                if (contextItem.context != context) continue;
                return contextItem;
            }
            CopyOnWriteIdentityListSet<ContextItem> copyOnWriteIdentityListSet = this.contexts;
            synchronized (copyOnWriteIdentityListSet) {
                if (contextItems == this.contexts.toList()) {
                    ContextItem item = this.doCreateContextItem(context);
                    this.contexts.add((Object)item);
                    return item;
                }
            }
        }
    }

    protected ContextItem doCreateContextItem(WorkingContext context) {
        return new ContextItem(context);
    }

    @Override
    public void addElementChangedListener(ElementChangedListener listener, WorkingContext context) {
        ContextItem contextItem = this.getContextItemCreate(context);
        contextItem.listeners.add((Object)listener);
    }

    @Override
    public void removeElementChangedListener(ElementChangedListener listener, WorkingContext context) {
        ContextItem contextItem = this.getContextItem(context);
        if (contextItem != null) {
            contextItem.listeners.remove((Object)listener);
        }
    }

    protected ImIdentityList<ElementChangedListener> getElementChangedListeners(WorkingContext context) {
        ContextItem contextItem = this.getContextItem(context);
        if (contextItem == null) {
            return NO_LISTENERS;
        }
        return contextItem.listeners.toList();
    }

    @Override
    public void refresh(WorkingContext context) {
        new RefreshJob(context, 0x2000003).schedule();
    }

    @Override
    public void registerDependentUnit(SourceUnit su) {
    }

    @Override
    public void deregisterDependentUnit(SourceUnit su) {
    }

    protected static class ContextItem {
        public final WorkingContext context;
        public final CopyOnWriteIdentityListSet<ElementChangedListener> listeners = new CopyOnWriteIdentityListSet();

        protected ContextItem(WorkingContext context) {
            this.context = context;
        }

        public final int hashCode() {
            return this.context.hashCode();
        }

        public final boolean equals(@Nullable Object obj) {
            return this == obj;
        }
    }

    private class RefreshJob
    extends Job {
        private final List<SourceUnit> list;
        private final int flags;

        public RefreshJob(WorkingContext context, int flags) {
            super("Model Refresh");
            this.setUser(false);
            this.setSystem(true);
            this.setPriority(50);
            this.list = LtkModels.getSourceUnitManager().getOpenSourceUnits(AbstractModelManager.this.typeId, context);
            this.flags = flags;
        }

        protected IStatus run(IProgressMonitor monitor) {
            for (SourceUnit su : this.list) {
                su.getModelInfo(null, this.flags, monitor);
            }
            return Status.OK_STATUS;
        }
    }
}

