/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.util;

import java.util.regex.Pattern;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.string.Chars;

@NonNullByDefault
public final class StringUtils {
    private static final String SPACES_400 = "                                                                                                                                                                                                                                                                                                                                                                                                                ";
    private static final String TABS_200 = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";
    public static final Pattern U_LINEBREAK_PATTERN = Pattern.compile("\\R");
    private static final String STOP = new String("STOP");

    @Deprecated
    public static String formatCodePoint(int cp) {
        return Chars.formatCodePoint(cp);
    }

    /*
     * Unable to fully structure code
     */
    public static int firstIndexOfNonTrim(String s, int start, int end) {
        if (start >= 0 && end <= s.length()) ** GOTO lbl4
        throw new StringIndexOutOfBoundsException();
lbl-1000:
        // 1 sources

        {
            ++start;
lbl4:
            // 2 sources

            ** while (start < end && s.charAt((int)start) <= ' ')
        }
lbl5:
        // 1 sources

        return start;
    }

    public static int firstIndexOfNonTrim(String s) {
        int start = 0;
        int end = s.length();
        while (start < end && s.charAt(start) <= ' ') {
            ++start;
        }
        return start;
    }

    /*
     * Unable to fully structure code
     */
    public static int lastIndexOfNonTrim(String s, int start, int end) {
        if (start >= 0 && end <= s.length()) ** GOTO lbl4
        throw new StringIndexOutOfBoundsException();
lbl-1000:
        // 1 sources

        {
            --end;
lbl4:
            // 2 sources

            ** while (start < end && s.charAt((int)(end - 1)) <= ' ')
        }
lbl5:
        // 1 sources

        return end;
    }

    public static int lastIndexOfNonTrim(String s) {
        int end = s.length();
        while (end > 0 && s.charAt(end - 1) <= ' ') {
            --end;
        }
        return end;
    }

    /*
     * Unable to fully structure code
     */
    public static String trim(String s, int start, int end) {
        if (start < 0 || end > s.length()) {
            throw new StringIndexOutOfBoundsException();
        }
        if (start != 0 || end != s.length()) ** GOTO lbl6
        return s.trim();
lbl-1000:
        // 1 sources

        {
            ++start;
lbl6:
            // 2 sources

            ** while (start < end && s.charAt((int)start) <= ' ')
        }
lbl7:
        // 2 sources

        while (start < end && s.charAt(end - 1) <= ' ') {
            --end;
        }
        return s.substring(start, end);
    }

    public static boolean isTrimEmpty(String s) {
        int start = 0;
        int end = s.length();
        while (start < end && s.charAt(start) <= ' ') {
            ++start;
        }
        return start == end;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isTrimEmpty(String s, int start, int end) {
        if (start >= 0 && end <= s.length()) ** GOTO lbl4
        throw new StringIndexOutOfBoundsException();
lbl-1000:
        // 1 sources

        {
            ++start;
lbl4:
            // 2 sources

            ** while (start < end && s.charAt((int)start) <= ' ')
        }
lbl5:
        // 1 sources

        return start == end;
    }

    public static boolean containsAny(String s, ImCollection<String> searchStrings) {
        String prevString = null;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) continue;
            prevString = searchString;
            if (s.indexOf(searchString) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(StringBuilder s, ImCollection<String> searchStrings) {
        String prevString = null;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) continue;
            prevString = searchString;
            if (s.indexOf(searchString) < 0) continue;
            return true;
        }
        return false;
    }

    public static int firstIndexOfAny(String s, ImCollection<String> searchStrings, int fromIndex) {
        if (fromIndex < 0 || fromIndex > s.length()) {
            throw new StringIndexOutOfBoundsException(fromIndex);
        }
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) continue;
            prevString = searchString;
            int index = s.indexOf(searchString, fromIndex);
            if (index < 0 || index >= matchIndex) continue;
            matchIndex = index;
        }
        return matchIndex != Integer.MAX_VALUE ? matchIndex : -1;
    }

    public static int firstIndexOfAny(String s, ImCollection<String> searchStrings) {
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) continue;
            prevString = searchString;
            int index = s.indexOf(searchString);
            if (index < 0 || index >= matchIndex) continue;
            matchIndex = index;
        }
        return matchIndex != Integer.MAX_VALUE ? matchIndex : -1;
    }

    public static int firstIndexOfAny(StringBuilder s, ImCollection<String> searchStrings, int fromIndex) {
        if (fromIndex < 0 || fromIndex > s.length()) {
            throw new StringIndexOutOfBoundsException(fromIndex);
        }
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) continue;
            prevString = searchString;
            int index = s.indexOf(searchString, fromIndex);
            if (index < 0 || index >= matchIndex) continue;
            matchIndex = index;
        }
        return matchIndex != Integer.MAX_VALUE ? matchIndex : -1;
    }

    public static int firstIndexOfAny(StringBuilder s, ImCollection<String> searchStrings) {
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) continue;
            prevString = searchString;
            int index = s.indexOf(searchString);
            if (index < 0 || index >= matchIndex) continue;
            matchIndex = index;
        }
        return matchIndex != Integer.MAX_VALUE ? matchIndex : -1;
    }

    public static @Nullable Match firstMatchOfAny(String s, ImCollection<String> searchStrings, int fromIndex) {
        if (fromIndex < 0 || fromIndex > s.length()) {
            throw new StringIndexOutOfBoundsException(fromIndex);
        }
        String matchString = null;
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        boolean prevMatch = false;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) {
                if (!prevMatch || !s.startsWith(searchString, matchIndex)) continue;
                matchString = prevString = searchString;
                continue;
            }
            int index = s.indexOf(searchString, fromIndex);
            prevMatch = index >= 0 && (index < matchIndex || index == matchIndex && searchString.length() > matchString.length());
            if (prevMatch) {
                matchString = searchString;
                matchIndex = index;
            }
            prevString = searchString;
        }
        return matchString != null ? new Match(matchString, matchIndex) : null;
    }

    public static @Nullable Match firstMatchOfAny(String s, ImCollection<String> searchStrings) {
        String matchString = null;
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        boolean prevMatch = false;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) {
                if (!prevMatch || !s.startsWith(searchString, matchIndex)) continue;
                matchString = searchString;
                continue;
            }
            int index = s.indexOf(searchString);
            prevMatch = index >= 0 && (index < matchIndex || index == matchIndex && searchString.length() > matchString.length());
            if (prevMatch) {
                matchString = searchString;
                matchIndex = index;
            }
            prevString = searchString;
        }
        return matchString != null ? new Match(matchString, matchIndex) : null;
    }

    public static @Nullable Match firstMatchOfAny(StringBuilder s, ImCollection<String> searchStrings, int fromIndex) {
        if (fromIndex < 0 || fromIndex > s.length()) {
            throw new StringIndexOutOfBoundsException(fromIndex);
        }
        String matchString = null;
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        boolean prevMatch = false;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) {
                if (!prevMatch || matchIndex + searchString.length() > s.length() || !s.substring(matchIndex, matchIndex + searchString.length()).equals(searchString)) continue;
                matchString = prevString = searchString;
                continue;
            }
            int index = s.indexOf(searchString, fromIndex);
            prevMatch = index >= 0 && (index < matchIndex || index == matchIndex && searchString.length() > matchString.length());
            if (prevMatch) {
                matchString = searchString;
                matchIndex = index;
            }
            prevString = searchString;
        }
        return matchString != null ? new Match(matchString, matchIndex) : null;
    }

    public static @Nullable Match firstMatchOfAny(StringBuilder s, ImCollection<String> searchStrings) {
        String matchString = null;
        int matchIndex = Integer.MAX_VALUE;
        String prevString = null;
        boolean prevMatch = false;
        for (String searchString : searchStrings) {
            if (prevString != null && searchString.startsWith(prevString)) {
                if (!prevMatch || matchIndex + searchString.length() > s.length() || !s.substring(matchIndex, matchIndex + searchString.length()).equals(searchString)) continue;
                matchString = prevString = searchString;
                continue;
            }
            int index = s.indexOf(searchString);
            prevMatch = index >= 0 && (index < matchIndex || index == matchIndex && searchString.length() > matchString.length());
            if (prevMatch) {
                matchString = searchString;
                matchIndex = index;
            }
            prevString = searchString;
        }
        return matchString != null ? new Match(matchString, matchIndex) : null;
    }

    public static String replace(String s, int startIndex, int endIndex, String str) {
        int sLength = s.length();
        if (startIndex < 0 || startIndex > endIndex || endIndex > sLength) {
            throw new IndexOutOfBoundsException();
        }
        StringBuilder sb = new StringBuilder(sLength - (endIndex - startIndex) + str.length());
        if (sLength <= sb.capacity()) {
            sb.append(s);
            sb.replace(startIndex, endIndex, str);
        } else {
            sb.append(s, 0, startIndex);
            sb.append(str);
            sb.append(s, endIndex, sLength);
        }
        return sb.toString();
    }

    public static String insert(String s, int index, String str) {
        StringBuilder sb = new StringBuilder(s.length() + str.length());
        sb.append(s);
        sb.insert(index, str);
        return sb.toString();
    }

    public static String insert(String s, int index, char c) {
        StringBuilder sb = new StringBuilder(s.length() + 1);
        sb.append(s);
        sb.insert(index, c);
        return sb.toString();
    }

    public static @Nullable String firstNonEmpty(@Nullable String s1, @Nullable String s2) {
        if (s1 != null && !s1.isEmpty()) {
            return s1;
        }
        if (s2 != null && !s2.isEmpty()) {
            return s2;
        }
        return null;
    }

    public static @Nullable String firstNonEmpty(String ... strings) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string != null && !string.isEmpty()) {
                return string;
            }
            ++n2;
        }
        return null;
    }

    public static final void appendTrim(StringBuilder sb, String s) {
        sb.append(s, StringUtils.firstIndexOfNonTrim(s), StringUtils.lastIndexOfNonTrim(s));
    }

    public static final void appendTrim(StringBuilder sb, String s, int startIndex, int endIndex) {
        sb.append(s, StringUtils.firstIndexOfNonTrim(s, startIndex, endIndex), StringUtils.lastIndexOfNonTrim(s, startIndex, endIndex));
    }

    public static final void appendSpaces(StringBuilder sb, int num) {
        switch (num) {
            case 0: {
                return;
            }
            case 1: {
                sb.append(' ');
                return;
            }
        }
        while (num > 400) {
            sb.append(SPACES_400);
            num -= 400;
        }
        sb.append(SPACES_400, 0, num);
    }

    public static final void insertSpaces(StringBuilder sb, int index, int num) {
        switch (num) {
            case 0: {
                return;
            }
            case 1: {
                sb.insert(index, ' ');
                return;
            }
        }
        while (num > 400) {
            sb.insert(index, SPACES_400);
            num -= 400;
            index += 400;
        }
        sb.insert(index, SPACES_400, 0, num);
    }

    public static final void appendTabs(StringBuilder sb, int num) {
        switch (num) {
            case 0: {
                return;
            }
            case 1: {
                sb.append('\t');
                return;
            }
        }
        while (num > 200) {
            sb.append(TABS_200);
            num -= 200;
        }
        sb.append(TABS_200, 0, num);
    }

    public static final void insertTabs(StringBuilder sb, int index, int num) {
        switch (num) {
            case 0: {
                return;
            }
            case 1: {
                sb.insert(index, '\t');
                return;
            }
        }
        while (num > 200) {
            sb.insert(index, TABS_200);
            num -= 200;
            index += 200;
        }
        sb.insert(index, TABS_200, 0, num);
    }

    public static String toSimpleSingleLine(String text) {
        int length = text.length();
        StringBuilder escaped = null;
        int idxWritten = 0;
        int idx = 0;
        block6: while (idx < length) {
            String replacement;
            char c = text.charAt(idx);
            switch (c) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u001b': 
                case '\u001c': 
                case '\u001e': 
                case '\u001f': 
                case '\u007f': 
                case '\u0080': 
                case '\u0081': 
                case '\u0082': 
                case '\u0083': 
                case '\u0084': 
                case '\u0085': 
                case '\u0086': 
                case '\u0087': 
                case '\u0088': 
                case '\u0089': 
                case '\u008a': 
                case '\u008b': 
                case '\u008c': 
                case '\u008d': 
                case '\u008e': 
                case '\u008f': 
                case '\u0090': 
                case '\u0091': 
                case '\u0092': 
                case '\u0093': 
                case '\u0094': 
                case '\u0095': 
                case '\u0096': 
                case '\u0097': 
                case '\u0098': 
                case '\u0099': 
                case '\u009a': 
                case '\u009b': 
                case '\u009c': 
                case '\u009d': 
                case '\u009e': 
                case '\u009f': {
                    replacement = null;
                    break;
                }
                case '\t': {
                    replacement = "  ";
                    break;
                }
                case '\n': {
                    replacement = idx < length - 1 ? " \u2014 " : STOP;
                    break;
                }
                case '\f': {
                    replacement = STOP;
                    break;
                }
                default: {
                    ++idx;
                    continue block6;
                }
            }
            if (replacement == STOP) {
                if (escaped == null) {
                    return text.substring(0, idx);
                }
                if (idx > idxWritten) {
                    escaped.append(text, idxWritten, idx);
                }
                return escaped.toString();
            }
            if (escaped == null) {
                escaped = new StringBuilder(length + 16);
            }
            if (idx > idxWritten) {
                escaped.append(text, idxWritten, idx);
            }
            if (replacement != null) {
                escaped.append(replacement);
            }
            idxWritten = ++idx;
        }
        if (escaped == null) {
            return text;
        }
        if (length > idxWritten) {
            escaped.append(text, idxWritten, length);
        }
        return escaped.toString();
    }

    private StringUtils() {
    }

    public static final class Match {
        private final String string;
        private final int startIndex;

        public Match(String string, int startIndex) {
            this.string = ObjectUtils.nonNullAssert(string);
            this.startIndex = startIndex;
        }

        public String getString() {
            return this.string;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.startIndex + this.string.length();
        }

        public int getLength() {
            return this.string.length();
        }
    }
}

