/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.ts.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.ts.core.ToolCommandData;

@NonNullByDefault
public class BasicToolCommandData
implements ToolCommandData {
    protected static final Object INCOMPATIBLE = new Object();
    private final Map<String, ?> data;
    private final Map<String, @Nullable Object> returnData = new HashMap<String, Object>();

    public BasicToolCommandData(Map<String, ?> data) {
        this.data = data;
    }

    public BasicToolCommandData() {
        this.data = Map.of();
    }

    @Override
    public @Nullable Object getRawData(String key) {
        return this.data.get(key);
    }

    protected @Nullable Object getData(String key) {
        Object data = this.returnData.get(key);
        if (data == null) {
            data = this.getRawData(key);
        }
        return data;
    }

    @Override
    public <TData> @Nullable TData get(String key, Class<TData> type) {
        Object rawData = this.getData(key);
        if (rawData != null) {
            if (type.isInstance(rawData)) {
                return (TData)rawData;
            }
            Object typedData = this.convert(rawData, type);
            if (typedData == INCOMPATIBLE) {
                throw new ToolCommandData.IllegalDataException(String.format("Data entry '%1$s' is incompatible (%2$s).", key, rawData.getClass().getName()));
            }
            return (TData)typedData;
        }
        return null;
    }

    protected Map<String, @Nullable Object> getReturnData() {
        return this.returnData;
    }

    public boolean hasReturnData() {
        return !this.returnData.isEmpty();
    }

    @Override
    public void setReturnData(String key, @Nullable Object value) {
        this.returnData.put(key, value);
    }

    @Override
    public void removeReturnData(String key) {
        this.returnData.remove(key);
    }

    protected @Nullable Object convert(@Nullable Object data, Class<?> type) {
        Object[] array;
        if (data != null && data.getClass().isArray() && data.getClass().getComponentType().isAssignableFrom(type) && (array = (Object[])data).length == 1) {
            data = array[0];
        }
        if (data == null || type.isInstance(data)) {
            return data;
        }
        if (type == Integer.class && data instanceof Number) {
            return ((Number)data).intValue();
        }
        if (type == Double.class && data instanceof Number) {
            return ((Number)data).doubleValue();
        }
        return INCOMPATIBLE;
    }
}

