/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.string;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.string.BasicStringFactory;
import org.eclipse.statet.jcommons.string.CharArrayString;
import org.eclipse.statet.jcommons.string.StringFactory;

@NonNullByDefault
public class CacheStringFactory
implements StringFactory {
    private static final int HASHSET_SIZE = 1024;
    private static final int HASHSET_MASK = 1023;
    private final String[] values = new String[1024];
    private final int maxCachedLength;

    public CacheStringFactory(int maxCachedLength) {
        this.maxCachedLength = maxCachedLength;
    }

    @Override
    public String get(CharSequence s) {
        switch (s.length()) {
            case 0: {
                return "";
            }
            case 1: {
                char c0 = s.charAt(0);
                if (c0 < '\u0100') {
                    return BasicStringFactory.getCharString(c0);
                }
                return this.getDefault(c0, s);
            }
            case 2: {
                char c1;
                char c0 = s.charAt(0);
                if (c0 >= '\u0100' || (c1 = s.charAt(1)) >= '\u0100') break;
                return BasicStringFactory.getPairString(c0 * 256 + c1);
            }
            default: {
                if (s.length() <= this.maxCachedLength) break;
                return s.toString();
            }
        }
        return this.getDefault(s);
    }

    @Override
    public String get(CharArrayString s) {
        switch (s.length()) {
            case 0: {
                return "";
            }
            case 1: {
                char c0 = s.charAt(0);
                if (c0 < '\u0100') {
                    return BasicStringFactory.getCharString(c0);
                }
                return this.getDefault(c0, s);
            }
            case 2: {
                char c1;
                char c0 = s.charAt(0);
                if (c0 >= '\u0100' || (c1 = s.charAt(1)) >= '\u0100') break;
                return BasicStringFactory.getPairString(c0 * 256 + c1);
            }
            default: {
                if (s.length() <= this.maxCachedLength) break;
                return s.toString();
            }
        }
        return this.getDefault(s);
    }

    @Override
    public String get(String s) {
        switch (s.length()) {
            case 0: {
                return "";
            }
            case 1: {
                char c0 = s.charAt(0);
                if (c0 < '\u0100') {
                    return BasicStringFactory.getCharString(c0);
                }
                return this.getDefault(c0, s);
            }
            case 2: {
                char c1;
                char c0 = s.charAt(0);
                if (c0 >= '\u0100' || (c1 = s.charAt(1)) >= '\u0100') break;
                return BasicStringFactory.getPairString(c0 * 256 + c1);
            }
            default: {
                if (s.length() <= this.maxCachedLength) break;
                return s;
            }
        }
        return this.getDefault(s);
    }

    @Override
    public String get(char c) {
        if (c < '\u0100') {
            return BasicStringFactory.getCharString(c);
        }
        int i1 = c - 256 & 0x3FF;
        String s1 = this.values[i1];
        if (s1 != null && s1.length() == 1 && s1.charAt(0) == c) {
            return s1;
        }
        this.values[i1] = String.valueOf(c);
        return this.values[i1];
    }

    @Override
    public String get(int codepoint) {
        if (codepoint >= 0 && codepoint < 256) {
            return BasicStringFactory.getCharString(codepoint);
        }
        if (codepoint >= 0 && codepoint <= 65535) {
            return this.get((char)codepoint);
        }
        return this.get(Character.toString(codepoint));
    }

    private int computeHash(CharSequence s) {
        int hashCode = 0;
        int length = s.length();
        int index = 0;
        while (length-- != 0) {
            hashCode = 31 * hashCode + s.charAt(index++);
        }
        return hashCode;
    }

    private String getDefault(char c, CharSequence s) {
        int i1 = c - 256 & 0x3FF;
        String s1 = this.values[i1];
        if (s1 != null && s1.length() == 1 && s1.charAt(0) == c) {
            return s1;
        }
        this.values[i1] = s.toString();
        return this.values[i1];
    }

    private String getDefault(CharArrayString s) {
        int hashCode = s.hashCode();
        int i1 = hashCode & 0x3FF;
        String s1 = this.values[i1];
        if (s1 != null && s.contentEquals(s1)) {
            return s1;
        }
        this.values[i1] = s.toString();
        return this.values[i1];
    }

    private String getDefault(CharSequence s) {
        int hashCode = this.computeHash(s);
        int i1 = hashCode & 0x3FF;
        String s1 = this.values[i1];
        if (s1 != null && s1.hashCode() == hashCode && s1.contentEquals(s)) {
            return s1;
        }
        this.values[i1] = s.toString();
        return this.values[i1];
    }

    private String getDefault(String s) {
        int hashCode = s.hashCode();
        int i1 = hashCode & 0x3FF;
        String s1 = this.values[i1];
        if (s1 != null && s1.hashCode() == hashCode && s1.equals(s)) {
            return s1;
        }
        this.values[i1] = s;
        return this.values[i1];
    }
}

