/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.collections;

import java.util.NoSuchElementException;
import java.util.stream.LongStream;
import org.eclipse.statet.internal.jcommons.collections.AbstractImLongList;
import org.eclipse.statet.jcommons.collections.LongList;
import org.eclipse.statet.jcommons.collections.LongListIterator;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ImLongSingletonList
extends AbstractImLongList {
    private final long e0;

    public ImLongSingletonList(long e) {
        this.e0 = e;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(long e) {
        return this.e0 == e;
    }

    @Override
    public long getAt(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return this.e0;
    }

    @Override
    public long getFirst() {
        return this.e0;
    }

    @Override
    public long getLast() {
        return this.e0;
    }

    @Override
    public int indexOf(long e) {
        return this.e0 == e ? 0 : -1;
    }

    @Override
    public int lastIndexOf(long e) {
        return this.e0 == e ? 0 : -1;
    }

    @Override
    public LongListIterator iterator() {
        return new Iter(0);
    }

    @Override
    public LongListIterator listIterator(int index) {
        if ((index & 0xFFFFFFFE) != 0) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return new Iter(index);
    }

    @Override
    public LongStream stream() {
        return LongStream.of(this.e0);
    }

    @Override
    public long[] toArray() {
        return new long[]{this.e0};
    }

    @Override
    public void toArray(long[] array) {
        array[0] = this.e0;
    }

    @Override
    public void copyTo(int srcIndex, long[] dest, int destIndex, int length) {
        assert (length == 1);
        dest[destIndex] = this.e0;
    }

    @Override
    public void copyTo(long[] dest, int destIndex) {
        dest[destIndex] = this.e0;
    }

    public int hashCode() {
        int hashCode = 7;
        hashCode = 31 * hashCode + Long.hashCode(this.e0);
        return hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LongList) {
            LongList other = (LongList)obj;
            return 1 == other.size() && this.e0 == other.getFirst();
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.e0);
        sb.append(']');
        return sb.toString();
    }

    private class Iter
    extends AbstractImLongList.AbstractImLongListIter {
        private int cursor;

        Iter(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < 1;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public long nextLong() {
            if (this.cursor >= 1) {
                throw new NoSuchElementException();
            }
            ++this.cursor;
            return ImLongSingletonList.this.e0;
        }

        @Override
        public Long next() {
            if (this.cursor >= 1) {
                throw new NoSuchElementException();
            }
            ++this.cursor;
            return ImLongSingletonList.this.e0;
        }

        @Override
        public long nextLongElse(long elseLong) {
            if (this.cursor >= 1) {
                return elseLong;
            }
            ++this.cursor;
            return ImLongSingletonList.this.e0;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public long previousLong() {
            if (this.cursor <= 0) {
                throw new NoSuchElementException();
            }
            --this.cursor;
            return ImLongSingletonList.this.e0;
        }

        @Override
        public Long previous() {
            if (this.cursor <= 0) {
                throw new NoSuchElementException();
            }
            --this.cursor;
            return ImLongSingletonList.this.e0;
        }
    }
}

