/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.net.core.sshd;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyPair;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.future.DefaultCancellableSshFuture;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.future.VerifiableFuture;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.session.SessionContext;
import org.eclipse.jgit.internal.transport.sshd.AuthenticationLogger;
import org.eclipse.statet.internal.jcommons.net.core.sshd.Messages;
import org.eclipse.statet.internal.jcommons.net.core.sshd.util.ChainingAttributes;
import org.eclipse.statet.jcommons.collections.CollectionUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.net.core.ssh.OpenSshConfigUtils;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.util.function.CallableE;

@NonNullByDefault
public class SshdUtils {
    public static AttributeRepository chain(@Nullable AttributeRepository self, @Nullable AttributeRepository parent) {
        if (self == null) {
            return (AttributeRepository)ObjectUtils.nonNullAssert((Object)parent);
        }
        if (parent == null || parent == self) {
            return self;
        }
        return new ChainingAttributes(self, parent);
    }

    public static KeyIdentityProvider toKeyIdentityProvider(final Iterable<KeyPair> keys) {
        if (keys instanceof KeyIdentityProvider) {
            return (KeyIdentityProvider)keys;
        }
        return new KeyIdentityProvider(){

            public Iterable<KeyPair> loadKeys(@Nullable SessionContext session) {
                return keys;
            }
        };
    }

    public static List<URI> determineHops(List<URI> currentHops, HostConfigEntry hostConfig, String host) throws IOException {
        String jumpHosts;
        if (currentHops.isEmpty() && (jumpHosts = hostConfig.getProperty("ProxyJump")) != null && !jumpHosts.isEmpty() && !"none".equals(jumpHosts)) {
            try {
                return OpenSshConfigUtils.parseProxyJump((String)jumpHosts);
            }
            catch (URISyntaxException e) {
                throw new IOException(MessageFormat.format(Messages.get().configInvalidProxyJump, host, jumpHosts), e);
            }
        }
        return currentHops;
    }

    public static String attachAuthLog(String message, @Nullable AuthenticationLogger authLog) {
        String log;
        if (authLog != null && !(log = CollectionUtils.toString((List)authLog.getLog(), (String)"\n")).isEmpty()) {
            return message + "\n" + log;
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends SshFuture<T>> T verify(VerifiableFuture<T> future, long startTime, @Nullable Duration timeout, ProgressMonitor m) throws IOException, StatusException {
        long timeoutTime = startTime + (timeout != null ? timeout.toNanos() : Long.MAX_VALUE);
        if (future instanceof DefaultCancellableSshFuture) {
            DefaultCancellableSshFuture f = (DefaultCancellableSshFuture)future;
            class FutureListener
            implements SshFutureListener<T> {
                FutureListener() {
                }

                public synchronized void operationComplete(T future) {
                    this.notifyAll();
                }
            }
            FutureListener listener = new FutureListener();
            f.addListener((SshFutureListener)listener);
            try {
                while (!f.isDone()) {
                    if (m.isCanceled()) {
                        f.cancel();
                        throw new StatusException(Status.CANCEL_STATUS);
                    }
                    long remaining = timeoutTime - System.nanoTime();
                    if (remaining <= 0L) break;
                    FutureListener futureListener = listener;
                    synchronized (futureListener) {
                        try {
                            listener.wait(Math.min(remaining / 1000000L, 50L));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                SshFuture sshFuture = (SshFuture)future.verify(0L);
                return (T)sshFuture;
            }
            finally {
                f.removeListener((SshFutureListener)listener);
            }
        }
        long remaining = timeoutTime - System.nanoTime();
        return (T)((SshFuture)future.verify(remaining, TimeUnit.NANOSECONDS));
    }

    public static <T extends SshFuture<T>> T verify(CallableE<VerifiableFuture<T>, IOException> op, @Nullable Duration timeout, ProgressMonitor m) throws IOException, StatusException {
        long startTime = System.nanoTime();
        VerifiableFuture future = (VerifiableFuture)op.get();
        return SshdUtils.verify(future, startTime, timeout, m);
    }

    private SshdUtils() {
    }
}

