/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ide.core;

import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.osgi.framework.BundleContext;

@NonNullByDefault
public final class BaseCorePlugin
extends Plugin {
    private static @Nullable BaseCorePlugin instance;
    private boolean started;
    private final CopyOnWriteArraySet<Disposable> disposables = new CopyOnWriteArraySet();

    public static BaseCorePlugin getInstance() {
        return instance;
    }

    public BaseCorePlugin() {
        instance = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            BaseCorePlugin baseCorePlugin = this;
            synchronized (baseCorePlugin) {
                this.started = false;
            }
            try {
                for (Disposable listener : this.disposables) {
                    listener.dispose();
                }
            }
            finally {
                this.disposables.clear();
            }
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    public void addStopListener(Disposable listener) {
        this.disposables.add(listener);
    }

    public void removeStopListener(Disposable listener) {
        this.disposables.remove(listener);
    }
}

