/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.eutils.autonature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.internal.eutils.autonature.Activator;
import org.eclipse.statet.internal.eutils.autonature.AutoConfig;
import org.eclipse.statet.internal.eutils.autonature.ConfigManager;
import org.eclipse.statet.internal.eutils.autonature.UIUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.service.prefs.BackingStoreException;

@NonNullByDefault
public class AutoNaturePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private List<AutoConfig> configs;
    private Button enableButton;
    private CheckboxTableViewer entryViewer;

    public void init(@Nullable IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
        this.enableButton = new Button(composite, 32);
        this.enableButton.setText("Enable automatic project &configuration.");
        this.enableButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
        Label label = new Label(composite, 0);
        label.setText("Enable project configuration for:");
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ViewerUtils.CheckboxTableComposite tableComposite = UIUtils.createContentTypeTable(composite, 1);
        this.entryViewer = tableComposite.viewer;
        Dialog.applyDialogFont((Control)composite);
        this.loadConfigs();
        this.loadPrefs();
        return composite;
    }

    private void loadConfigs() {
        ConfigManager configManager = Activator.getInstance().getConfigManager();
        List<AutoConfig> configs = configManager.getConfigs((byte)1);
        UIUtils.sortConfigs(configs);
        this.configs = configs;
        this.entryViewer.setInput(configs);
    }

    private void loadPrefs() {
        IPreferencesService preferences = Platform.getPreferencesService();
        this.enableButton.setSelection(preferences.getBoolean("org.eclipse.statet.eutils.autonature", "enabled", true, null));
        ArrayList<AutoConfig> checked = new ArrayList<AutoConfig>();
        for (AutoConfig config : this.configs) {
            if (!preferences.getBoolean("org.eclipse.statet.eutils.autonature/configurations", config.getEnabledPrefKey(), false, null)) continue;
            checked.add(config);
        }
        this.entryViewer.setCheckedElements(checked.toArray());
    }

    private void savePrefs(boolean flush) {
        IEclipsePreferences bundleNode = InstanceScope.INSTANCE.getNode("org.eclipse.statet.eutils.autonature");
        bundleNode.putBoolean("enabled", this.enableButton.getSelection());
        IEclipsePreferences configsNode = InstanceScope.INSTANCE.getNode("org.eclipse.statet.eutils.autonature/configurations");
        List<Object> enabled = Arrays.asList(this.entryViewer.getCheckedElements());
        for (AutoConfig config : this.configs) {
            configsNode.putBoolean(config.getEnabledPrefKey(), enabled.contains(config));
        }
        if (flush) {
            try {
                bundleNode.flush();
            }
            catch (BackingStoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.eutils.autonature", -1, "An error occured when saving the autorun launch configuration.", (Throwable)e));
            }
        }
    }

    protected void performDefaults() {
        this.enableButton.setSelection(true);
        IEclipsePreferences configsNode = DefaultScope.INSTANCE.getNode("org.eclipse.statet.eutils.autonature/configurations");
        ArrayList<AutoConfig> checked = new ArrayList<AutoConfig>();
        for (AutoConfig config : this.configs) {
            if (!configsNode.getBoolean(config.getEnabledPrefKey(), false)) continue;
            checked.add(config);
        }
        this.entryViewer.setCheckedElements(checked.toArray());
    }

    protected void performApply() {
        this.savePrefs(true);
    }

    public boolean performOk() {
        this.savePrefs(false);
        return true;
    }
}

