/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell.decorator;

import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCellPainter;
import org.eclipse.statet.ecommons.waltable.core.style.BorderStyle;
import org.eclipse.statet.ecommons.waltable.core.style.CellStyling;
import org.eclipse.statet.ecommons.waltable.core.style.Style;
import org.eclipse.statet.ecommons.waltable.core.swt.SwtUtils;
import org.eclipse.statet.ecommons.waltable.painter.cell.CellPainterWrapper;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.style.CellStyleUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class LineBorderDecorator
extends CellPainterWrapper {
    private final BorderStyle defaultBorderStyle;

    public LineBorderDecorator(LayerCellPainter interiorPainter) {
        this(interiorPainter, null);
    }

    public LineBorderDecorator(LayerCellPainter interiorPainter, BorderStyle defaultBorderStyle) {
        super(interiorPainter);
        this.defaultBorderStyle = defaultBorderStyle;
    }

    @Override
    public long getPreferredWidth(LayerCell cell, GC gc, ConfigRegistry configRegistry) {
        BorderStyle borderStyle = this.getBorderStyle(cell, configRegistry);
        long padding = borderStyle != null ? Math.max(borderStyle.getOffset() + borderStyle.getThickness(), 0) : 0;
        return super.getPreferredWidth(cell, gc, configRegistry) + padding * 2L;
    }

    @Override
    public long getPreferredHeight(LayerCell cell, GC gc, ConfigRegistry configRegistry) {
        BorderStyle borderStyle = this.getBorderStyle(cell, configRegistry);
        long padding = borderStyle != null ? Math.max(borderStyle.getOffset() + borderStyle.getThickness(), 0) : 0;
        return super.getPreferredHeight(cell, gc, configRegistry) + padding * 2L;
    }

    private BorderStyle getBorderStyle(LayerCell cell, ConfigRegistry configRegistry) {
        Style cellStyle = CellStyleUtil.getCellStyle(cell, configRegistry);
        BorderStyle borderStyle = cellStyle.getAttributeValue(CellStyling.BORDER_STYLE);
        if (borderStyle == null) {
            borderStyle = this.defaultBorderStyle;
        }
        return borderStyle;
    }

    @Override
    public void paintCell(LayerCell cell, GC gc, LRectangle lRectangle, ConfigRegistry configRegistry) {
        BorderStyle borderStyle = this.getBorderStyle(cell, configRegistry);
        long padding = borderStyle != null ? Math.max(borderStyle.getOffset() + borderStyle.getThickness(), 0) : 0;
        LRectangle interiorBounds = new LRectangle(lRectangle.x + padding, lRectangle.y + padding, lRectangle.width - padding * 2L, lRectangle.height - padding * 2L);
        super.paintCell(cell, gc, interiorBounds, configRegistry);
        if (borderStyle == null || borderStyle.getThickness() <= 0) {
            return;
        }
        Color originalForeground = gc.getForeground();
        int originalLineWidth = gc.getLineWidth();
        int originalLineStyle = gc.getLineStyle();
        long borderOffset = borderStyle.getOffset();
        int borderThickness = borderStyle.getThickness();
        long shift = 0L;
        long areaShift = 0L;
        if (borderThickness % 2 == 0) {
            shift = borderThickness / 2;
            areaShift = shift * 2L;
        } else {
            shift = borderThickness / 2;
            areaShift = shift * 2L + 1L;
        }
        LRectangle borderArea = new LRectangle(lRectangle.x + borderOffset + shift, lRectangle.y + borderOffset + shift, lRectangle.width - borderOffset * 2L - areaShift, lRectangle.height - borderOffset * 2L - areaShift);
        gc.setLineWidth(borderThickness);
        gc.setLineStyle(SwtUtils.toSWT(borderStyle.getLineStyle()));
        gc.setForeground(borderStyle.getColor());
        gc.drawRectangle(GraphicsUtils.safe(borderArea));
        gc.setForeground(originalForeground);
        gc.setLineWidth(originalLineWidth);
        gc.setLineStyle(originalLineStyle);
    }
}

