/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell;

import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.style.CellStyling;
import org.eclipse.statet.ecommons.waltable.core.style.Style;
import org.eclipse.statet.ecommons.waltable.painter.cell.TextPainter;
import org.eclipse.statet.ecommons.waltable.style.CellStyleUtil;
import org.eclipse.swt.graphics.GC;

public class PasswordTextPainter
extends TextPainter {
    private Character echoChar = Character.valueOf('\u2022');

    public PasswordTextPainter() {
    }

    public PasswordTextPainter(boolean wrapText, boolean paintBg) {
        super(wrapText, paintBg);
    }

    public PasswordTextPainter(boolean wrapText, boolean paintBg, int spacing) {
        super(wrapText, paintBg, spacing);
    }

    public PasswordTextPainter(boolean wrapText, boolean paintBg, boolean calculate) {
        super(wrapText, paintBg, calculate);
    }

    public PasswordTextPainter(boolean wrapText, boolean paintBg, int spacing, boolean calculate) {
        super(wrapText, paintBg, spacing, calculate);
    }

    @Override
    public void paintCell(LayerCell cell, GC gc, LRectangle lRectangle, ConfigRegistry configRegistry) {
        Style cellStyle = CellStyleUtil.getCellStyle(cell, configRegistry);
        Character configEchoChar = cellStyle.getAttributeValue(CellStyling.PASSWORD_ECHO_CHAR);
        if (configEchoChar != null) {
            this.echoChar = configEchoChar;
        }
        super.paintCell(cell, gc, lRectangle, configRegistry);
    }

    @Override
    protected String getTextToDisplay(LayerCell cell, GC gc, long availableLength, String text) {
        String result = super.getTextToDisplay(cell, gc, availableLength, text);
        return result.replaceAll(".", this.echoChar.toString());
    }
}

