/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.grid.core.layers;

import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.coordinate.PositionOutOfBoundsException;
import org.eclipse.statet.ecommons.waltable.core.layer.AbstractLayer;
import org.eclipse.statet.ecommons.waltable.core.layer.BasicLayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.BasicLayerCellDim;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerPainter;
import org.eclipse.statet.ecommons.waltable.core.swt.painters.CellLayerPainter;
import org.eclipse.statet.ecommons.waltable.data.core.DataLayerDim;
import org.eclipse.statet.ecommons.waltable.grid.core.layers.DimensionallyDependentLayer;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class PlaceholderLayer
extends DimensionallyDependentLayer {
    public PlaceholderLayer(@Nullable Layer horizontalLayerDependency, @Nullable Layer verticalLayerDependency) {
        this(horizontalLayerDependency, verticalLayerDependency, true, (LayerPainter)new CellLayerPainter());
    }

    public PlaceholderLayer(@Nullable Layer horizontalLayerDependency, @Nullable Layer verticalLayerDependency, boolean useDefaultConfiguration, LayerPainter layerPainter) {
        super(new DummyLayer(), layerPainter);
        this.setHorizontalLayerDependency(horizontalLayerDependency != null ? horizontalLayerDependency : this.getBaseLayer());
        this.setVerticalLayerDependency(verticalLayerDependency != null ? verticalLayerDependency : this.getBaseLayer());
    }

    public void setSize(int size) {
        ((DummyLayer)this.getBaseLayer()).size = size;
    }

    @Override
    public LayerCell getCellByPosition(long columnPosition, long rowPosition) {
        Object hDim = this.getDim(Orientation.HORIZONTAL);
        Object vDim = this.getDim(Orientation.VERTICAL);
        long columnId = hDim.getPositionId(columnPosition, columnPosition);
        long rowId = vDim.getPositionId(rowPosition, rowPosition);
        return new BasicLayerCell(this, new BasicLayerCellDim(Orientation.HORIZONTAL, columnId, columnPosition, 0L, hDim.getPositionCount()), new BasicLayerCellDim(Orientation.VERTICAL, rowId, rowPosition, 0L, vDim.getPositionCount()));
    }

    private static class DummyLayer
    extends AbstractLayer<DataLayerDim<DummyLayer>>
    implements Layer {
        private static long idCounter;
        private final long id = 0x100000000000000L + idCounter++;
        private int size = 20;

        public DummyLayer() {
            this.init();
        }

        @Override
        protected DataLayerDim<DummyLayer> createDim(Orientation orientation) {
            return new Dim(this, orientation, this.id);
        }

        @Override
        public @Nullable Layer getUnderlyingLayerByPosition(long columnPosition, long rowPosition) {
            return null;
        }

        @Override
        public LayerCell getCellByPosition(long columnPosition, long rowPosition) {
            throw new UnsupportedOperationException();
        }

        private static class Dim
        extends DataLayerDim<DummyLayer> {
            public Dim(DummyLayer layer, Orientation orientation, long catId) {
                super(layer, orientation, catId);
            }

            @Override
            public long getPositionCount() {
                return 1L;
            }

            @Override
            public long getSize() {
                return ((DummyLayer)this.layer).size;
            }

            @Override
            public long getPositionByPixel(long pixel) {
                return 0L;
            }

            @Override
            public long getPositionStart(long position) {
                if (position != 0L) {
                    throw new PositionOutOfBoundsException(position, this.getOrientation());
                }
                return 0L;
            }

            @Override
            public int getPositionSize(long position) {
                if (position != 0L) {
                    throw new PositionOutOfBoundsException(position, this.getOrientation());
                }
                return ((DummyLayer)this.layer).size;
            }

            @Override
            public boolean isPositionResizable(long position) {
                return false;
            }
        }
    }
}

