/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.freeze;

import java.util.List;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionCoordinate;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerEvent;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerListener;
import org.eclipse.statet.ecommons.waltable.core.layer.events.StructuralChangeEvent;
import org.eclipse.statet.ecommons.waltable.core.layer.events.StructuralDiff;
import org.eclipse.statet.ecommons.waltable.freeze.FreezeLayer;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class FreezeEventHandler
implements LayerListener {
    private final FreezeLayer freezeLayer;

    public FreezeEventHandler(FreezeLayer freezeLayer) {
        this.freezeLayer = freezeLayer;
    }

    @Override
    public void handleLayerEvent(LayerEvent event) {
        if (event instanceof StructuralChangeEvent) {
            List<StructuralDiff> rowDiffs;
            StructuralChangeEvent changeEvent = (StructuralChangeEvent)event;
            PositionCoordinate topLeftPosition = this.freezeLayer.getTopLeftPosition();
            PositionCoordinate bottomRightPosition = this.freezeLayer.getBottomRightPosition();
            List<StructuralDiff> columnDiffs = changeEvent.getDiffs(Orientation.HORIZONTAL);
            if (columnDiffs != null) {
                int leftOffset = 0;
                int rightOffset = 0;
                int freezeMove = 0;
                block8: for (StructuralDiff diff : columnDiffs) {
                    long start = diff.getBeforePositionRange().start;
                    switch (diff.getDiffType()) {
                        case ADD: {
                            if (start < topLeftPosition.columnPosition) {
                                leftOffset = (int)((long)leftOffset + diff.getAfterPositionRange().size());
                            }
                            if (start > bottomRightPosition.columnPosition && (freezeMove != 1 || start != bottomRightPosition.columnPosition + 1L)) continue block8;
                            rightOffset = (int)((long)rightOffset + diff.getAfterPositionRange().size());
                            break;
                        }
                        case DELETE: {
                            if (start < topLeftPosition.columnPosition) {
                                leftOffset = (int)((long)leftOffset - (Math.min(diff.getBeforePositionRange().end, topLeftPosition.columnPosition + 1L) - start));
                            }
                            if (start <= bottomRightPosition.columnPosition) {
                                rightOffset = (int)((long)rightOffset - (Math.min(diff.getBeforePositionRange().end, bottomRightPosition.columnPosition + 1L) - start));
                                if (freezeMove != 0) break;
                                freezeMove = 1;
                                break;
                            }
                            freezeMove = -1;
                            break;
                        }
                    }
                }
                topLeftPosition.columnPosition += (long)leftOffset;
                bottomRightPosition.columnPosition += (long)rightOffset;
            }
            if ((rowDiffs = changeEvent.getDiffs(Orientation.VERTICAL)) != null) {
                int leftOffset = 0;
                int rightOffset = 0;
                int freezeMove = 0;
                block9: for (StructuralDiff diff : rowDiffs) {
                    long start = diff.getBeforePositionRange().start;
                    switch (diff.getDiffType()) {
                        case ADD: {
                            if (start < topLeftPosition.rowPosition) {
                                leftOffset = (int)((long)leftOffset + diff.getAfterPositionRange().size());
                            }
                            if (start > bottomRightPosition.rowPosition && (freezeMove != 1 || start != bottomRightPosition.rowPosition + 1L)) continue block9;
                            rightOffset = (int)((long)rightOffset + diff.getAfterPositionRange().size());
                            break;
                        }
                        case DELETE: {
                            if (start < topLeftPosition.rowPosition) {
                                leftOffset = (int)((long)leftOffset - (Math.min(diff.getBeforePositionRange().end, topLeftPosition.rowPosition + 1L) - start));
                            }
                            if (start <= bottomRightPosition.rowPosition) {
                                rightOffset = (int)((long)rightOffset - (Math.min(diff.getBeforePositionRange().end, bottomRightPosition.rowPosition + 1L) - start));
                                if (freezeMove != 0) break;
                                freezeMove = 1;
                                break;
                            }
                            freezeMove = -1;
                            break;
                        }
                    }
                }
                topLeftPosition.rowPosition += (long)leftOffset;
                bottomRightPosition.rowPosition += (long)rightOffset;
            }
        }
    }
}

