/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.layer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.statet.ecommons.waltable.config.IConfiguration;
import org.eclipse.statet.ecommons.waltable.core.Persistable;
import org.eclipse.statet.ecommons.waltable.core.command.LayerCommand;
import org.eclipse.statet.ecommons.waltable.core.command.LayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.coordinate.PixelOutOfBoundsException;
import org.eclipse.statet.ecommons.waltable.core.layer.ClientAreaProvider;
import org.eclipse.statet.ecommons.waltable.core.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerEvent;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerListener;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerPainter;
import org.eclipse.statet.ecommons.waltable.core.swt.painters.GridLineCellLayerPainter;
import org.eclipse.statet.ecommons.waltable.ui.binding.UiBindingRegistry;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public abstract class AbstractLayer<TLayerDim extends LayerDim>
implements Layer {
    private TLayerDim hDim = (LayerDim)ObjectUtils.nonNullLateInit();
    private TLayerDim vDim = (LayerDim)ObjectUtils.nonNullLateInit();
    private @Nullable LayerPainter layerPainter;
    private ClientAreaProvider clientAreaProvider = ClientAreaProvider.DEFAULT;
    private final Map<Class<? extends LayerCommand>, LayerCommandHandler<? extends LayerCommand>> commandHandlers = new LinkedHashMap<Class<? extends LayerCommand>, LayerCommandHandler<? extends LayerCommand>>();
    private final CopyOnWriteIdentityListSet<LayerListener> eventHandlers = new CopyOnWriteIdentityListSet();
    private final CopyOnWriteIdentityListSet<Persistable> persistables = new CopyOnWriteIdentityListSet();
    private final CopyOnWriteIdentityListSet<LayerListener> listeners = new CopyOnWriteIdentityListSet();
    private final Collection<IConfiguration> configurations = new ArrayList<IConfiguration>();

    protected AbstractLayer() {
    }

    protected AbstractLayer(@Nullable LayerPainter layerPainter) {
        this.layerPainter = layerPainter;
    }

    protected void init() {
        this.hDim = this.createDim(Orientation.HORIZONTAL);
        this.vDim = this.createDim(Orientation.VERTICAL);
        if (this.hDim.getOrientation() != Orientation.HORIZONTAL || this.vDim.getOrientation() != Orientation.VERTICAL) {
            throw new RuntimeException("Invalid LayerDim");
        }
    }

    protected abstract TLayerDim createDim(Orientation var1);

    public TLayerDim getDim(Orientation orientation) {
        switch (orientation) {
            case HORIZONTAL: {
                return this.hDim;
            }
            case VERTICAL: {
                return this.vDim;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void dispose() {
    }

    @Override
    public LabelStack getRegionLabelsByXY(long x, long y) {
        return new LabelStack();
    }

    @Override
    public void saveState(String prefix, Map<String, String> properties) {
        for (Persistable persistable : this.persistables) {
            persistable.saveState(prefix, properties);
        }
    }

    @Override
    public void loadState(String prefix, Map<String, String> properties) {
        for (Persistable persistable : this.persistables) {
            persistable.loadState(prefix, properties);
        }
    }

    @Override
    public void registerPersistable(Persistable persistable) {
        this.persistables.add((Object)persistable);
    }

    @Override
    public void unregisterPersistable(Persistable persistable) {
        this.persistables.remove((Object)persistable);
    }

    public void addConfiguration(IConfiguration configuration) {
        this.configurations.add(configuration);
    }

    public void clearConfiguration() {
        this.configurations.clear();
    }

    @Override
    public void configure(ConfigRegistry configRegistry, UiBindingRegistry uiBindingRegistry) {
        for (IConfiguration configuration : this.configurations) {
            configuration.configureLayer(this);
            configuration.configureRegistry(configRegistry);
            configuration.configureUiBindings(uiBindingRegistry);
        }
    }

    @Override
    public boolean doCommand(LayerCommand command) {
        for (Map.Entry<Class<? extends LayerCommand>, LayerCommandHandler<? extends LayerCommand>> entry : this.commandHandlers.entrySet()) {
            LayerCommandHandler<? extends LayerCommand> commandHandler;
            if (!entry.getKey().isInstance(command) || !(commandHandler = entry.getValue()).doCommand(this, command.cloneCommand())) continue;
            return true;
        }
        return false;
    }

    protected void registerCommandHandlers() {
    }

    @Override
    public void registerCommandHandler(LayerCommandHandler<?> commandHandler) {
        this.commandHandlers.put(commandHandler.getCommandClass(), commandHandler);
    }

    @Override
    public void unregisterCommandHandler(Class<? extends LayerCommand> commandClass) {
        this.commandHandlers.remove(commandClass);
    }

    @Override
    public void addLayerListener(LayerListener listener) {
        this.listeners.add((Object)((LayerListener)ObjectUtils.nonNullAssert((Object)listener)));
    }

    @Override
    public void removeLayerListener(LayerListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void handleLayerEvent(LayerEvent event) {
        for (LayerListener handler : this.eventHandlers) {
            handler.handleLayerEvent(event);
        }
        LayerEvent localEvent = event.toLayer(this);
        if (localEvent != null) {
            this.fireLayerEvent(localEvent);
        }
    }

    public void registerEventHandler(LayerListener eventHandler) {
        this.eventHandlers.add((Object)((LayerListener)ObjectUtils.nonNullAssert((Object)eventHandler)));
    }

    public void unregisterEventHandler(LayerListener eventHandler) {
        this.eventHandlers.remove((Object)eventHandler);
    }

    @Override
    public void fireLayerEvent(LayerEvent event) {
        for (LayerListener listener : this.listeners) {
            listener.handleLayerEvent(event);
        }
    }

    @Override
    public LayerPainter getLayerPainter() {
        LayerPainter layerPainter = this.layerPainter;
        if (layerPainter == null) {
            this.layerPainter = layerPainter = this.createPainter();
        }
        return layerPainter;
    }

    protected LayerPainter createPainter() {
        return new GridLineCellLayerPainter();
    }

    @Override
    public ClientAreaProvider getClientAreaProvider() {
        return this.clientAreaProvider;
    }

    @Override
    public void setClientAreaProvider(ClientAreaProvider clientAreaProvider) {
        this.clientAreaProvider = clientAreaProvider;
    }

    @Override
    public final long getColumnCount() {
        return this.hDim.getPositionCount();
    }

    @Override
    public final long getWidth() {
        return this.hDim.getSize();
    }

    @Override
    public final long getColumnPositionByX(long x) {
        try {
            return this.hDim.getPositionByPixel(x);
        }
        catch (PixelOutOfBoundsException e) {
            return Long.MIN_VALUE;
        }
    }

    @Override
    public final long getRowCount() {
        return this.vDim.getPositionCount();
    }

    @Override
    public final long getHeight() {
        return this.vDim.getSize();
    }

    @Override
    public final long getRowPositionByY(long y) {
        try {
            return this.vDim.getPositionByPixel(y);
        }
        catch (PixelOutOfBoundsException e) {
            return Long.MIN_VALUE;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

