/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.workbench.workspace;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public abstract class AbstractResourceSelectionDialog<TResource extends IResource>
extends SelectionStatusDialog {
    private IContainer rootContainer;
    private boolean allowNew;
    private TResource selectedResource;
    private Text textField;
    private boolean ignoreTextFieldModifications = false;

    public static IResource findExistingResource(IPath path, IContainer base) {
        IResource initialElement = null;
        if (path != null) {
            IContainer container = base;
            int nSegments = path.segmentCount();
            int i = 0;
            while (i < nSegments) {
                IResource elem = container.findMember(path.segment(i));
                if (elem != null) {
                    initialElement = elem;
                }
                if (!(elem instanceof IContainer)) break;
                container = (IContainer)elem;
                ++i;
            }
        }
        return initialElement;
    }

    public AbstractResourceSelectionDialog(Shell parent) {
        super(parent);
        this.setHelpAvailable(false);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected abstract String getDefaultMessage();

    protected abstract int getResourceTypes();

    public void setRootElement(IContainer container) {
        this.rootContainer = container;
    }

    protected IContainer getRootElement() {
        return this.rootContainer;
    }

    public void setAllowNewResources(boolean allowNew) {
        this.allowNew = allowNew;
    }

    protected boolean isAllowNewResources() {
        return this.allowNew;
    }

    public void setInitialElementSelection(IResource resource) {
        this.setInitialElementSelections((List)(resource != null ? ImCollections.newList((Object)resource) : null));
    }

    protected TResource getSelectedResource() {
        return this.selectedResource;
    }

    public void create() {
        if (this.rootContainer == null) {
            this.setRootElement((IContainer)ResourcesPlugin.getWorkspace().getRoot());
        }
        if (this.getMessage() == null) {
            this.setMessage(this.getDefaultMessage());
        }
        super.create();
        this.initDialog();
    }

    protected ISelectionChangedListener createSelectionChangeListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IResource selection = (IResource)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selection != null) {
                    AbstractResourceSelectionDialog.this.onResourceSelected(selection);
                    AbstractResourceSelectionDialog.this.validate();
                }
            }
        };
    }

    protected IDoubleClickListener createSelectionDoubleClickListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (AbstractResourceSelectionDialog.this.getOkButton().isEnabled()) {
                    AbstractResourceSelectionDialog.this.okPressed();
                }
            }
        };
    }

    protected void createTextField(Composite composite) {
        this.textField = new Text(composite, 2052);
        this.textField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textField.addModifyListener(e -> {
            if (!this.ignoreTextFieldModifications) {
                this.onTextChanged(this.textField.getText());
                this.validate();
            }
        });
    }

    protected void initSelection(List<IResource> checkedResources) {
    }

    protected IResource checkSelectionElement(Object o) {
        if (o instanceof IResource) {
            IResource resource = (IResource)o;
            IPath fullPath = resource.getFullPath();
            IPath rootPath = this.rootContainer.getFullPath();
            if (rootPath.isPrefixOf(fullPath)) {
                return AbstractResourceSelectionDialog.findExistingResource(fullPath.makeRelativeTo(rootPath), this.rootContainer);
            }
        }
        return null;
    }

    protected void initDialog() {
        List elements = this.getInitialElementSelections();
        if (!elements.isEmpty()) {
            ArrayList<IResource> checkedResources = new ArrayList<IResource>();
            for (Object o : elements) {
                IResource resource = this.checkSelectionElement(o);
                if (resource == null) continue;
                checkedResources.add(resource);
            }
            if (!checkedResources.isEmpty()) {
                this.initSelection(checkedResources);
            }
        }
        this.validate();
    }

    private void setSelectedResource0(IResource resource) {
        this.selectedResource = (resource.getType() & this.getResourceTypes()) != 0 ? resource : null;
    }

    protected void onTextChanged(String pathText) {
        pathText = pathText.trim();
        IResource resource = null;
        try {
            IPath path = new Path(pathText).makeRelative();
            resource = this.rootContainer.findMember(path);
            if (resource == null) {
                resource = path.hasTrailingSeparator() || (this.getResourceTypes() & 1) == 0 ? this.rootContainer.getFolder(path) : this.rootContainer.getFile(path);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.setSelectedResource0(resource);
    }

    protected void onResourceSelected(IResource resource) {
        this.setSelectedResource0(resource);
        this.ignoreTextFieldModifications = true;
        try {
            String pathText = resource != null ? resource.getFullPath().makeRelativeTo(this.rootContainer.getFullPath()).toString() : "";
            this.textField.setText(pathText);
        }
        finally {
            this.ignoreTextFieldModifications = false;
        }
    }

    protected void validate() {
        boolean isValid = false;
        TResource selectedResource = this.getSelectedResource();
        if (selectedResource != null) {
            IPath path = selectedResource.getFullPath();
            IStatus test = ResourcesPlugin.getWorkspace().validatePath(path.toString(), 1);
            isValid = test.getCode() == 0 && this.rootContainer.getFullPath().isPrefixOf(path) && (this.isAllowNewResources() || selectedResource.exists());
        }
        this.getOkButton().setEnabled(isValid);
    }

    protected void computeResult() {
        this.setSelectionResult(new IResource[]{this.getSelectedResource()});
    }

    public TResource getFirstResult() {
        return (TResource)((IResource)super.getFirstResult());
    }
}

