/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.workbench;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.expressions.Expression;
import org.eclipse.statet.ecommons.commands.core.AbstractHandlerCollection;
import org.eclipse.statet.ecommons.commands.core.HandlerCollection;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public class ContextHandlers
extends AbstractHandlerCollection<ContextCommandRecord>
implements HandlerCollection {
    private IHandlerService handlerService;
    private @Nullable Expression defaultActivationExpression;
    private boolean deactivateOnDisposal;

    public ContextHandlers(IHandlerService handlerService) {
        this.handlerService = handlerService;
    }

    public ContextHandlers(IServiceLocator serviceLocator) {
        this.handlerService = (IHandlerService)ObjectUtils.nonNullAssert((Object)((IHandlerService)serviceLocator.getService(IHandlerService.class)));
    }

    public final IHandlerService getHandlerService() {
        return this.handlerService;
    }

    public void setDefaultActivationExpression(Expression expression) {
        this.defaultActivationExpression = expression;
    }

    public void setDeactivateOnDisposal(boolean enabled) {
        this.deactivateOnDisposal = enabled;
    }

    protected ContextCommandRecord createCommandRecord(String commandId, IHandler2 handler, int flags) {
        return new ContextCommandRecord(handler, flags);
    }

    public void addActivate(String commandId, IHandler2 handler, int flags) {
        ContextCommandRecord record = (ContextCommandRecord)this.addCommandRecord(commandId, handler, flags);
        record.activation = this.handlerService.activateHandler(commandId, (IHandler)handler, this.defaultActivationExpression, false);
    }

    public void addActivate(String commandId, IHandler2 handler) {
        ContextCommandRecord record = (ContextCommandRecord)this.addCommandRecord(commandId, handler, 0);
        record.activation = this.handlerService.activateHandler(commandId, (IHandler)handler, this.defaultActivationExpression, false);
    }

    public void deactivate(int flags) {
        Collection records = this.getCommandRecords();
        ArrayList<IHandlerActivation> activations = new ArrayList<IHandlerActivation>(records.size());
        for (ContextCommandRecord record : records) {
            IHandlerActivation activation;
            if ((record.getFlags() & flags) == 0 || (activation = record.activation) == null) continue;
            record.activation = null;
            activations.add(activation);
        }
        this.handlerService.deactivateHandlers(activations);
    }

    public void deactivateAll() {
        Collection records = this.getCommandRecords();
        ArrayList<IHandlerActivation> activations = new ArrayList<IHandlerActivation>(records.size());
        for (ContextCommandRecord record : records) {
            IHandlerActivation activation = record.activation;
            if (activation == null) continue;
            record.activation = null;
            activations.add(activation);
        }
        this.handlerService.deactivateHandlers(activations);
    }

    public void dispose() {
        if (this.deactivateOnDisposal) {
            this.deactivateAll();
        }
        this.handlerService = null;
        super.dispose();
    }

    static class ContextCommandRecord
    extends AbstractHandlerCollection.CommandRecord {
        @Nullable IHandlerActivation activation;

        public ContextCommandRecord(IHandler2 handler, int flags) {
            super(handler, flags);
        }
    }
}

