/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.viewers.breadcrumb;

import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.statet.ecommons.ui.viewers.breadcrumb.BreadcrumbItem;
import org.eclipse.statet.ecommons.ui.viewers.breadcrumb.BreadcrumbMessages;
import org.eclipse.statet.ecommons.ui.viewers.breadcrumb.DropDownContributionItem;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

@NonNullByDefault
class BreadcrumbItemDropDown {
    private static boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jdt.ui/debug/BreadcrumbItemDropDown"));
    private static final boolean IS_MAC_WORKAROUND = "carbon".equals(SWT.getPlatform());
    private static final int DROP_DOWN_HIGHT = 300;
    private static final int DROP_DOWN_WIDTH = 500;
    private final BreadcrumbItem parent;
    private final Composite parentComposite;
    private final ToolBar toolBar;
    private boolean isMenuShown;
    private boolean isEnabled;
    private Shell shell;
    private TreeViewer dropDownViewer;
    private MenuManager dropDownMenuManager;

    public BreadcrumbItemDropDown(BreadcrumbItem parent, Composite composite) {
        this.parent = parent;
        this.parentComposite = composite;
        this.isMenuShown = false;
        this.isEnabled = true;
        ToolBar toolBar = new ToolBar(composite, 0x800000);
        toolBar.setData("org.eclipse.e4.ui.css.id", (Object)(parent.getViewer().getCssIdPrefix() + "BreadcrumbItemDropDownToolBar"));
        toolBar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = BreadcrumbMessages.BreadcrumbItemDropDown_showDropDownMenu_action_tooltip;
            }
        });
        toolBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.toolBar = toolBar;
        ToolBarManager manager = new ToolBarManager(this.toolBar);
        DropDownContributionItem dropDownContributionItem = new DropDownContributionItem(this.parentComposite.getStyle() & 0x4000000){

            @Override
            protected void handleWidgetSelection() {
                if (BreadcrumbItemDropDown.this.parent.getDropDownShell() != null) {
                    return;
                }
                Shell shell = BreadcrumbItemDropDown.this.parent.getViewer().getDropDownShell();
                if (shell != null) {
                    shell.close();
                }
                BreadcrumbItemDropDown.this.showMenu();
                BreadcrumbItemDropDown.this.shell.setFocus();
            }
        };
        manager.add((IContributionItem)dropDownContributionItem);
        manager.update(true);
        if (IS_MAC_WORKAROUND) {
            manager.getControl().addMouseListener((MouseListener)new MouseAdapter(dropDownContributionItem){
                private final /* synthetic */ 2 val$dropDownContributionItem;
                {
                    this.val$dropDownContributionItem = var2_2;
                }

                public void mouseDown(MouseEvent e) {
                    this.val$dropDownContributionItem.handleWidgetSelection();
                }
            });
        }
        this.dropDownMenuManager = new MenuManager();
        this.dropDownMenuManager.setRemoveAllWhenShown(true);
        this.dropDownMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Object selectedElement = ((IStructuredSelection)BreadcrumbItemDropDown.this.dropDownViewer.getSelection()).getFirstElement();
                if (selectedElement != null) {
                    BreadcrumbItemDropDown.this.parent.getViewer().fillDropDownContextMenu(manager, selectedElement);
                }
            }
        });
    }

    public int getWidth() {
        return this.toolBar.computeSize((int)-1, (int)-1).x;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        this.toolBar.setVisible(enabled);
    }

    public boolean isMenuShown() {
        return this.isMenuShown;
    }

    public @Nullable Shell getDropDownShell() {
        if (!this.isMenuShown()) {
            return null;
        }
        return this.shell;
    }

    public @Nullable ISelectionProvider getDropDownSelectionProvider() {
        if (!this.isMenuShown) {
            return null;
        }
        return this.dropDownViewer;
    }

    public void showMenu() {
        if (DEBUG) {
            System.out.println("BreadcrumbItemDropDown.showMenu()");
        }
        if (!this.isEnabled || this.isMenuShown) {
            return;
        }
        this.shell = new Shell(this.toolBar.getShell(), 16404);
        if (DEBUG) {
            System.out.println("\tcreating new shell");
        }
        try {
            this.isMenuShown = true;
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.shell.setLayout((Layout)layout);
            Composite composite = new Composite((Composite)this.shell, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            composite.setLayout((Layout)gridLayout);
            this.dropDownViewer = this.createViewer(composite);
            this.dropDownViewer.setUseHashlookup(true);
            final Tree tree = (Tree)this.dropDownViewer.getControl();
            tree.setLayoutData((Object)new GridData(4, 4, true, true));
            Object input = this.parent.getElement();
            this.parent.getViewer().configureDropDownViewer(this.dropDownViewer, input);
            this.dropDownViewer.setInput(input);
            this.setShellBounds(this.shell);
            this.dropDownViewer.addOpenListener(new IOpenListener(){

                public void open(OpenEvent event) {
                    ISelection selection;
                    if (DEBUG) {
                        System.out.println("BreadcrumbItemDropDown.showMenu()$treeViewer>open");
                    }
                    if (!((selection = event.getSelection()) instanceof IStructuredSelection)) {
                        return;
                    }
                    Object element = ((IStructuredSelection)selection).getFirstElement();
                    if (element == null) {
                        return;
                    }
                    BreadcrumbItemDropDown.this.openElement(element);
                }
            });
            tree.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                    if (DEBUG) {
                        System.out.println("BreadcrumbItemDropDown.showMenu()$treeViewer>mouseUp");
                    }
                    if (e.button != 1) {
                        return;
                    }
                    if ((OpenStrategy.getOpenMethod() & 1) != 0) {
                        return;
                    }
                    TreeItem item = tree.getItem(new Point(e.x, e.y));
                    if (item == null) {
                        return;
                    }
                    BreadcrumbItemDropDown.this.openElement(item.getData());
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
            tree.addMouseMoveListener(new MouseMoveListener(){
                @Nullable TreeItem lastItem = null;

                public void mouseMove(MouseEvent e) {
                    if (tree.equals(e.getSource())) {
                        TreeItem currentItem = tree.getItem(new Point(e.x, e.y));
                        if (!Objects.equals(currentItem, this.lastItem)) {
                            boolean showHandPointer = currentItem != null && BreadcrumbItemDropDown.this.parent.getViewer().canOpen(currentItem);
                            tree.setCursor(showHandPointer ? tree.getDisplay().getSystemCursor(21) : null);
                        }
                        if (currentItem != null) {
                            Rectangle clientArea = tree.getClientArea();
                            if (!currentItem.equals(this.lastItem)) {
                                this.lastItem = currentItem;
                                tree.setSelection(new TreeItem[]{this.lastItem});
                            } else if (e.y - clientArea.y < tree.getItemHeight() / 4) {
                                if (currentItem.getParentItem() == null) {
                                    int index = tree.indexOf(currentItem);
                                    if (index < 1) {
                                        return;
                                    }
                                    this.lastItem = tree.getItem(index - 1);
                                    tree.setSelection(new TreeItem[]{this.lastItem});
                                } else {
                                    Point p = tree.toDisplay(e.x, e.y);
                                    Item item = BreadcrumbItemDropDown.this.dropDownViewer.scrollUp(p.x, p.y);
                                    if (item instanceof TreeItem) {
                                        this.lastItem = (TreeItem)item;
                                        tree.setSelection(new TreeItem[]{this.lastItem});
                                    }
                                }
                            } else if (clientArea.y + clientArea.height - e.y < tree.getItemHeight() / 4) {
                                if (currentItem.getParentItem() == null) {
                                    int index = tree.indexOf(currentItem);
                                    if (index >= tree.getItemCount() - 1) {
                                        return;
                                    }
                                    this.lastItem = tree.getItem(index + 1);
                                    tree.setSelection(new TreeItem[]{this.lastItem});
                                } else {
                                    Point p = tree.toDisplay(e.x, e.y);
                                    Item item = BreadcrumbItemDropDown.this.dropDownViewer.scrollDown(p.x, p.y);
                                    if (item instanceof TreeItem) {
                                        this.lastItem = (TreeItem)item;
                                        tree.setSelection(new TreeItem[]{this.lastItem});
                                    }
                                }
                            }
                        } else {
                            this.lastItem = null;
                        }
                    }
                }
            });
            tree.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 0x1000001) {
                        TreeItem[] selection = tree.getSelection();
                        if (selection.length != 1) {
                            return;
                        }
                        int selectionIndex = tree.indexOf(selection[0]);
                        if (selectionIndex != 0) {
                            return;
                        }
                        BreadcrumbItemDropDown.this.shell.close();
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
            tree.setMenu(this.dropDownMenuManager.createContextMenu((Control)tree));
            this.dropDownViewer.addTreeListener(new ITreeViewerListener(){

                public void treeCollapsed(TreeExpansionEvent event) {
                }

                public void treeExpanded(TreeExpansionEvent event) {
                    tree.setRedraw(false);
                    BreadcrumbItemDropDown.this.shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).BreadcrumbItemDropDown.this.shell.isDisposed()) {
                                return;
                            }
                            try {
                                BreadcrumbItemDropDown.this.resizeShell((this).BreadcrumbItemDropDown.this.shell);
                            }
                            finally {
                                tree.setRedraw(true);
                            }
                        }
                    });
                }
            });
            int index = this.parent.getViewer().getIndexOfItem(this.parent);
            if (index < this.parent.getViewer().getItemCount() - 1) {
                BreadcrumbItem childItem = this.parent.getViewer().getItem(index + 1);
                Object childElement = childItem.getElement();
                this.dropDownViewer.setSelection((ISelection)new StructuredSelection(childElement), true);
                TreeItem[] selection = tree.getSelection();
                if (selection.length > 0) {
                    tree.setTopItem(selection[0]);
                }
            }
            this.shell.setVisible(true);
            this.installCloser(this.shell);
        }
        catch (RuntimeException e) {
            this.isMenuShown = false;
            this.shell.close();
            throw e;
        }
    }

    protected TreeViewer createViewer(Composite composite) {
        return new TreeViewer(composite, 772);
    }

    private void openElement(@Nullable Object data) {
        boolean treeHasFocus;
        if (data == null) {
            return;
        }
        this.parent.getViewer().fireMenuSelection(data);
        boolean bl = treeHasFocus = !this.shell.isDisposed() && this.dropDownViewer.getTree().isFocusControl();
        if (DEBUG) {
            System.out.println("\tisDisposed: " + this.shell.isDisposed());
            System.out.println("\tshell hasFocus: " + (!this.shell.isDisposed() && this.shell.isFocusControl()));
            System.out.println("\ttree hasFocus: " + treeHasFocus);
        }
        if (this.shell.isDisposed()) {
            return;
        }
        if (!treeHasFocus) {
            this.shell.close();
            return;
        }
        this.toggleExpansionState(data);
    }

    private void toggleExpansionState(Object element) {
        Tree tree = this.dropDownViewer.getTree();
        if (this.dropDownViewer.getExpandedState(element)) {
            this.dropDownViewer.collapseToLevel(element, 1);
        } else {
            tree.setRedraw(false);
            try {
                this.dropDownViewer.expandToLevel(element, 1);
                this.resizeShell(this.shell);
            }
            finally {
                tree.setRedraw(true);
            }
        }
    }

    private void installCloser(final Shell shell) {
        final Listener focusListener = new Listener(){

            public void handleEvent(Event event) {
                Widget focusElement = event.widget;
                boolean isFocusBreadcrumbTreeFocusWidget = focusElement == shell || focusElement instanceof Tree && ((Tree)focusElement).getShell() == shell;
                boolean isFocusWidgetParentShell = focusElement instanceof Control && ((Control)focusElement).getShell().getParent() == shell;
                switch (event.type) {
                    case 15: {
                        if (DEBUG) {
                            System.out.println("focusIn - is breadcrumb tree: " + isFocusBreadcrumbTreeFocusWidget);
                        }
                        if (isFocusBreadcrumbTreeFocusWidget || isFocusWidgetParentShell) break;
                        if (DEBUG) {
                            System.out.println("==> closing shell since focus in other widget");
                        }
                        shell.close();
                        break;
                    }
                    case 16: {
                        if (DEBUG) {
                            System.out.println("focusOut - is breadcrumb tree: " + isFocusBreadcrumbTreeFocusWidget);
                        }
                        if (event.display.getActiveShell() != null) break;
                        if (DEBUG) {
                            System.out.println("==> closing shell since event.display.getActiveShell() == null");
                        }
                        shell.close();
                        break;
                    }
                    default: {
                        Assert.isTrue((boolean)false);
                    }
                }
            }
        };
        final Display display = shell.getDisplay();
        display.addFilter(15, focusListener);
        display.addFilter(16, focusListener);
        final ControlListener controlListener = new ControlListener(){

            public void controlMoved(ControlEvent e) {
                shell.close();
            }

            public void controlResized(ControlEvent e) {
                shell.close();
            }
        };
        this.toolBar.getShell().addControlListener(controlListener);
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (DEBUG) {
                    System.out.println("==> shell disposed");
                }
                display.removeFilter(15, focusListener);
                display.removeFilter(16, focusListener);
                if (!BreadcrumbItemDropDown.this.toolBar.isDisposed()) {
                    BreadcrumbItemDropDown.this.toolBar.getShell().removeControlListener(controlListener);
                }
            }
        });
        shell.addShellListener(new ShellListener(){

            public void shellActivated(ShellEvent e) {
            }

            public void shellClosed(ShellEvent e) {
                if (DEBUG) {
                    System.out.println("==> shellClosed");
                }
                if (!BreadcrumbItemDropDown.this.isMenuShown) {
                    return;
                }
                BreadcrumbItemDropDown.this.isMenuShown = false;
                BreadcrumbItemDropDown.this.dropDownViewer = null;
            }

            public void shellDeactivated(ShellEvent e) {
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellIconified(ShellEvent e) {
            }
        });
    }

    private void setShellBounds(Shell shell) {
        Rectangle rect = this.parentComposite.getBounds();
        Rectangle toolbarBounds = this.toolBar.getBounds();
        shell.pack();
        Point size = shell.getSize();
        int height = Math.min(size.y, 300);
        int width = Math.max(Math.min(size.x, 500), 250);
        int imageBoundsX = 0;
        if (this.dropDownViewer.getTree().getItemCount() > 0) {
            TreeItem item = this.dropDownViewer.getTree().getItem(0);
            imageBoundsX = item.getImageBounds((int)0).x;
        }
        Rectangle trim = this.shell.computeTrim(0, 0, width, height);
        int x = toolbarBounds.x + toolbarBounds.width + 2 + trim.x - imageBoundsX;
        if (!this.isLTR()) {
            x += width;
        }
        Point pt = new Point(x, rect.y + rect.height);
        pt = this.parentComposite.toDisplay(pt);
        Rectangle monitor = Util.getClosestMonitor((Display)shell.getDisplay(), (Point)pt).getClientArea();
        int overlap = pt.x + width - (monitor.x + monitor.width);
        if (overlap > 0) {
            pt.x -= overlap;
        }
        if (pt.x < monitor.x) {
            pt.x = monitor.x;
        }
        shell.setLocation(pt);
        shell.setSize(width, height);
    }

    private void resizeShell(Shell shell) {
        Point size = shell.getSize();
        int currentWidth = size.x;
        int currentHeight = size.y;
        if (currentHeight >= 300 && currentWidth >= 500) {
            return;
        }
        Point preferedSize = shell.computeSize(-1, -1, true);
        int newWidth = currentWidth >= 500 ? currentWidth : Math.min(Math.max(preferedSize.x, currentWidth), 500);
        int newHeight = currentHeight >= 300 ? currentHeight : Math.min(Math.max(preferedSize.y, currentHeight), 300);
        if (newHeight != currentHeight || newWidth != currentWidth) {
            shell.setRedraw(false);
            try {
                shell.setSize(newWidth, newHeight);
                if (!this.isLTR()) {
                    Point location = shell.getLocation();
                    shell.setLocation(location.x - (newWidth - currentWidth), location.y);
                }
            }
            finally {
                shell.setRedraw(true);
            }
        }
    }

    private boolean isLTR() {
        return (this.parentComposite.getStyle() & 0x4000000) == 0;
    }
}

