/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.contexts.NestableContextService;
import org.eclipse.ui.internal.handlers.LegacyHandlerService;
import org.eclipse.ui.internal.services.IServiceLocatorCreator;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.internal.services.WorkbenchLocationService;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IServiceLocator;

public class NestedServices
implements Listener {
    private final String name;
    private IEclipseContext context;
    private ServiceLocator serviceLocator;
    private boolean isActivated;

    public NestedServices(IServiceLocator parent, String name) {
        this(name, parent);
        this.initializeDefaultServices();
    }

    protected NestedServices(String name, IServiceLocator parent) {
        this.name = name;
        IServiceLocatorCreator slc = (IServiceLocatorCreator)parent.getService(IServiceLocatorCreator.class);
        IEclipseContext parentContext = (IEclipseContext)parent.getService(IEclipseContext.class);
        this.context = parentContext.createChild(name);
        this.serviceLocator = (ServiceLocator)slc.createServiceLocator(parent, null, new IDisposable(){

            public void dispose() {
                NestedServices.this.clear();
            }
        }, this.context);
        if (this.serviceLocator == null) {
            throw new RuntimeException("Could not create nested service locator.");
        }
    }

    protected <T> void registerService(Class<T> api, T service) {
        this.serviceLocator.registerService(api, service);
    }

    protected void initializeDefaultServices() {
        this.registerService(IContextService.class, new NestableContextService((IContextService)this.context.getParent().get(IContextService.class), null));
        this.registerService(IHandlerService.class, new LegacyHandlerService(this.context, null));
    }

    public void dispose() {
        if (this.serviceLocator != null) {
            this.serviceLocator.dispose();
            this.clear();
        }
    }

    private void clear() {
        if (this.serviceLocator != null) {
            this.serviceLocator = null;
            this.context.dispose();
            this.context = null;
        }
    }

    public IServiceLocator getLocator() {
        return this.serviceLocator;
    }

    public IEclipseContext getContext() {
        return this.context;
    }

    public void bindTo(Control control) {
        control.addListener(26, (Listener)this);
        control.addListener(15, (Listener)this);
        control.addListener(27, (Listener)this);
        control.addListener(12, (Listener)this);
    }

    public void bindToFocus(Control control) {
        control.addListener(26, (Listener)this);
        control.addListener(15, (Listener)this);
        control.addListener(16, (Listener)this);
        control.addListener(12, (Listener)this);
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 15: 
            case 26: {
                if (this.serviceLocator == null || this.isActivated) break;
                this.activate(event);
                break;
            }
            case 16: 
            case 27: {
                if (this.serviceLocator == null || !this.isActivated) break;
                this.deactivate(event);
                break;
            }
            case 12: {
                this.dispose();
                break;
            }
        }
    }

    protected void activate(Event event) {
        this.isActivated = true;
        this.context.activate();
        event.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (NestedServices.this.serviceLocator != null && NestedServices.this.isActivated) {
                    NestedServices.this.context.processWaiting();
                    NestedServices.this.serviceLocator.activate();
                }
            }
        });
    }

    protected void deactivate(Event event) {
        this.isActivated = false;
        this.serviceLocator.deactivate();
        this.context.deactivate();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NestedServices");
        sb.append(" '").append(this.name).append("'");
        if (this.serviceLocator == null) {
            sb.append(" (disposed)");
        }
        return sb.toString();
    }

    public static class Dialog
    extends NestedServices {
        public Dialog(Shell shell) {
            super("Dialog", (IServiceLocator)PlatformUI.getWorkbench());
            this.registerService(IWorkbenchLocationService.class, new WorkbenchLocationService("org.eclipse.ui.services.IDialog", PlatformUI.getWorkbench(), null, null, null, null, 1));
            this.initializeDefaultServices();
            IContextService contextService = (IContextService)this.getLocator().getService(IContextService.class);
            contextService.registerShell(shell, 0);
            this.bindTo((Control)shell);
        }
    }
}

