/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.swt.util;

import java.util.Arrays;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.statet.ecommons.ui.swt.SwtUtils;
import org.eclipse.statet.ecommons.ui.swt.util.ArrowImageDataProvider;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

@NonNullByDefault
public final class AccessibleArrowImage
extends CompositeImageDescriptor {
    public static final int DEFAULT_SIZE = 5;
    private final int direction;
    private final int size;
    private final RGB foregroundColor;

    public AccessibleArrowImage(int direction, int size, RGB widgetForegroundColor, RGB widgetBackgroundColor) {
        switch (direction) {
            case 128: 
            case 1024: 
            case 16384: 
            case 131072: {
                this.direction = direction;
                break;
            }
            default: {
                throw new IllegalArgumentException("direction: " + direction);
            }
        }
        this.size = size == -1 ? 5 : size;
        this.foregroundColor = ArrowImageDataProvider.computeDefaultForegroundColor(widgetForegroundColor, widgetBackgroundColor);
    }

    protected void drawCompositeImage(int width, int height) {
        int imgWidth;
        int yOffset;
        int xOffset;
        int imgHeight = switch (this.direction) {
            case 128 -> {
                xOffset = 0;
                yOffset = 0;
                imgWidth = this.size * 2 - 1;
                yield this.size;
            }
            case 1024 -> {
                xOffset = 0;
                yOffset = this.size % 2;
                imgWidth = this.size * 2 - 1;
                yield this.size;
            }
            case 16384 -> {
                xOffset = 0;
                yOffset = 0;
                imgWidth = this.size;
                yield this.size * 2 - 1;
            }
            case 131072 -> {
                xOffset = this.size % 2;
                yOffset = 0;
                imgWidth = this.size;
                yield this.size * 2 - 1;
            }
            default -> throw new IllegalStateException();
        };
        ImageDataProvider imageProvider = zoom -> {
            ImageData imageData;
            Display display = Display.getCurrent();
            Throwable throwable = null;
            Object var7_8 = null;
            try (SwtUtils.AutoDisposeReference<Image> managedImage = SwtUtils.autoDispose(new Image((Device)display, imgWidth, imgHeight));){
                imageData = managedImage.get().getImageData(zoom);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (imageData.alphaData == null) {
                imageData.alphaData = new byte[imageData.width * imageData.height];
            } else if (imageData.alphaData[0] != 0) {
                Arrays.fill(imageData.alphaData, (byte)0);
            }
            int foreground = imageData.palette.getPixel(this.foregroundColor);
            switch (this.direction) {
                case 128: {
                    int size1 = imageData.width / 2 + imageData.width % 2 - 1;
                    int size2 = size1 * 2;
                    int i = 0;
                    while (i <= size1) {
                        int fix1 = size1 - i;
                        int last2 = size2 - i;
                        imageData.setPixel(i, fix1, foreground);
                        imageData.setAlpha(i, fix1, 191);
                        int j = i + 1;
                        while (j < last2) {
                            imageData.setPixel(j, fix1, foreground);
                            imageData.setAlpha(j, fix1, 255);
                            ++j;
                        }
                        imageData.setPixel(last2, fix1, foreground);
                        imageData.setAlpha(last2, fix1, 191);
                        ++i;
                    }
                    break;
                }
                case 1024: {
                    int size1 = imageData.width / 2 + imageData.width % 2 - 1;
                    int size2 = size1 * 2;
                    int i = 0;
                    while (i <= size1) {
                        int fix1 = i;
                        int last2 = size2 - i;
                        imageData.setPixel(i, fix1, foreground);
                        imageData.setAlpha(i, fix1, 191);
                        int j = i + 1;
                        while (j < last2) {
                            imageData.setPixel(j, fix1, foreground);
                            imageData.setAlpha(j, fix1, 255);
                            ++j;
                        }
                        imageData.setPixel(last2, fix1, foreground);
                        imageData.setAlpha(last2, fix1, 191);
                        ++i;
                    }
                    break;
                }
                case 16384: {
                    int size1 = imageData.height / 2 + imageData.height % 2 - 1;
                    int size2 = size1 * 2;
                    int i = 0;
                    while (i <= size1) {
                        int fix1 = size1 - i;
                        int last2 = size2 - i;
                        imageData.setPixel(fix1, i, foreground);
                        imageData.setAlpha(fix1, i, 191);
                        int j = i + 1;
                        while (j < last2) {
                            imageData.setPixel(fix1, j, foreground);
                            imageData.setAlpha(fix1, j, 255);
                            ++j;
                        }
                        imageData.setPixel(fix1, last2, foreground);
                        imageData.setAlpha(fix1, last2, 191);
                        ++i;
                    }
                    break;
                }
                case 131072: {
                    int size1 = imageData.height / 2 + imageData.height % 2 - 1;
                    int size2 = size1 * 2;
                    int i = 0;
                    while (i <= size1) {
                        int fix1 = i;
                        int last2 = size2 - i;
                        imageData.setPixel(fix1, i, foreground);
                        imageData.setAlpha(fix1, i, 191);
                        int j = i + 1;
                        while (j < last2) {
                            imageData.setPixel(fix1, j, foreground);
                            imageData.setAlpha(fix1, j, 255);
                            ++j;
                        }
                        imageData.setPixel(fix1, last2, foreground);
                        imageData.setAlpha(fix1, last2, 191);
                        ++i;
                    }
                    break;
                }
            }
            return imageData;
        };
        this.drawImage(imageProvider, xOffset + (width - imgWidth) / 2, yOffset + (height - imgHeight) / 2);
    }

    protected Point getSize() {
        int corr = this.size % 2 == 0 ? -1 : 0;
        switch (this.direction) {
            case 128: 
            case 1024: {
                return new Point(this.size * 3 + corr, this.size * 2);
            }
            case 16384: 
            case 131072: {
                return new Point(this.size * 2, this.size * 3 + corr);
            }
        }
        throw new IllegalStateException();
    }

    public int hashCode() {
        return this.direction * 7 + this.size * 3460 + this.foregroundColor.hashCode() * 343629;
    }

    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                if (this == obj) break block2;
                if (!(obj instanceof AccessibleArrowImage)) break block3;
                AccessibleArrowImage other = (AccessibleArrowImage)((Object)obj);
                if (this.direction == other.direction && this.size == other.size && this.foregroundColor.equals((Object)other.foregroundColor)) break block2;
            }
            return false;
        }
        return true;
    }
}

