/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;

@NonNullByDefault
public class SearchText
extends Composite {
    private final Text textControl;
    private final CopyOnWriteIdentityListSet<Listener> listeners = new CopyOnWriteIdentityListSet();
    private boolean typingChange = true;

    public SearchText(Composite parent) {
        this(parent, null, 2048);
    }

    public SearchText(Composite parent, @Nullable String initialText, int textStyle) {
        super(parent, 0);
        this.textControl = this.createText(this, textStyle);
        this.createClearTextButtonSupport(this);
        if (initialText != null) {
            this.setText(initialText);
            this.textControl.selectAll();
        }
        SWTListener swtListener = new SWTListener();
        this.addListener(11, swtListener);
    }

    public void addListener(Listener listener) {
        this.listeners.add((Object)((Listener)ObjectUtils.nonNullAssert((Object)listener)));
    }

    public void removeListener(Listener listener) {
        this.listeners.remove((Object)listener);
    }

    private void textChanged0() {
        boolean typingChange = this.typingChange;
        this.typingChange = true;
        for (Listener listener : this.listeners) {
            listener.textChanged(typingChange);
        }
    }

    private void okPressed0() {
        for (Listener listener : this.listeners) {
            listener.okPressed();
        }
    }

    private void downPressed0() {
        for (Listener listener : this.listeners) {
            listener.downPressed();
        }
    }

    public boolean setFocus() {
        return this.textControl.setFocus();
    }

    public void setMessage(String text) {
        this.textControl.setMessage(text);
    }

    public void setToolTipText(@Nullable String text) {
        this.textControl.setToolTipText(text);
    }

    public void setText(@Nullable String text) {
        this.typingChange = false;
        this.textControl.setText(text != null ? text : "");
    }

    public String getText() {
        return this.textControl.getText();
    }

    public Text getTextControl() {
        return this.textControl;
    }

    public void clearText() {
        this.setText(null);
        if (this.isVisible()) {
            this.textControl.setFocus();
        }
    }

    private Text createText(Composite parent, int style) {
        if (((style |= 0x4104) & 0x800) != 0) {
            style |= 0x80;
        }
        Text textControl = new Text((Composite)this, style);
        textControl.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = SearchText.this.getAccessibleMessage();
            }
        });
        textControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    SearchText.this.downPressed0();
                    e.doit = false;
                    return;
                }
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    SearchText.this.okPressed0();
                    e.doit = false;
                    return;
                }
            }
        });
        textControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchText.this.textChanged0();
            }
        });
        return textControl;
    }

    protected String getAccessibleMessage() {
        return this.textControl.getText();
    }

    private void createClearTextButtonSupport(Composite parent) {
        this.textControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    boolean alreadyClear = SearchText.this.textControl.getText().isEmpty();
                    SearchText.this.setText(null);
                    e.doit = alreadyClear;
                    return;
                }
            }
        });
        this.textControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.detail == 256) {
                    SearchText.this.clearText();
                }
            }
        });
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point textSize = this.textControl.computeSize(wHint, hHint, changed);
        Rectangle trim = this.computeTrim(0, 0, textSize.x, textSize.y);
        return new Point(trim.width, trim.height);
    }

    private void updateLayout() {
        Rectangle clientArea = this.getClientArea();
        this.textControl.setBounds(clientArea);
    }

    public static interface Listener {
        public void okPressed();

        public void downPressed();

        public void textChanged(boolean var1);
    }

    private class SWTListener
    implements org.eclipse.swt.widgets.Listener {
        private SWTListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 11: {
                    SearchText.this.updateLayout();
                    return;
                }
            }
        }
    }
}

