/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Cursor;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Characters;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.SourceSpan;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class StringCharactersSpan
extends SourceSpan {
    private static final Pattern PATTERN = Pattern.compile("(.(?: *[^\n `\\[\\]\\\\!<&*_]+)*).*", 32);
    private static final Map<String, Pattern> EXT_PATTERN = new HashMap<String, Pattern>();
    private static final char[] EXT_BUFFER = new char[256];
    private final Matcher matcher;

    private static final boolean isDefaultControlChar(char c) {
        switch (c) {
            case '\n': 
            case '!': 
            case '&': 
            case '*': 
            case '<': 
            case '[': 
            case '\\': 
            case ']': 
            case '_': 
            case '`': {
                return true;
            }
        }
        return false;
    }

    private static final synchronized Pattern getPattern(@Nullable String controlChars) {
        char[] chars = EXT_BUFFER;
        int n = 0;
        if (controlChars != null) {
            int j = 0;
            while (j < controlChars.length()) {
                int i;
                char c = controlChars.charAt(j);
                if (!StringCharactersSpan.isDefaultControlChar(c) && (i = Arrays.binarySearch(chars, 0, n, c)) < 0) {
                    if ((i ^= 0xFFFFFFFF) < n) {
                        System.arraycopy(chars, i, chars, i + 1, n - i);
                    }
                    chars[i] = c;
                    ++n;
                }
                ++j;
            }
        }
        if (n == 0) {
            return PATTERN;
        }
        String key = new String(chars, 0, n);
        Pattern pattern = EXT_PATTERN.get(key);
        if (pattern == null) {
            pattern = Pattern.compile("(.(?: *[^\n `\\[\\]\\\\!<&*_" + key + "]+)*).*", 32);
            EXT_PATTERN.put(key, pattern);
        }
        return pattern;
    }

    public StringCharactersSpan() {
        this(null);
    }

    public StringCharactersSpan(@Nullable String additional) {
        this.matcher = StringCharactersSpan.getPattern(additional).matcher("");
    }

    @Override
    public @Nullable Inline createInline(ProcessingContext context, Cursor cursor) {
        Matcher matcher = cursor.setup(this.matcher);
        if (matcher.matches()) {
            String group = matcher.group(1);
            int cursorLength = matcher.end(1) - matcher.regionStart();
            int startOffset = cursor.getOffset();
            return new Characters(cursor.getLineAtOffset(), startOffset, cursorLength, cursorLength, group);
        }
        return null;
    }
}

