/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import java.util.List;
import java.util.Objects;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public abstract class InlineWithNestedContents
extends Inline {
    private final ImList<Inline> contents;

    public InlineWithNestedContents(Line line, int offset, int length, int cursorLength, List<? extends Inline> contents) {
        super(line, offset, length, cursorLength);
        this.contents = ImCollections.toList(contents);
    }

    public ImList<Inline> getContents() {
        return this.contents;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getStartOffset(), this.getLength(), this.getContents());
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (super.equals(obj)) {
            InlineWithNestedContents other = (InlineWithNestedContents)obj;
            return this.getContents().equals(other.getContents());
        }
        return false;
    }

    @Override
    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder(this.getClass(), this.getClass());
        sb.addProp("startOffset", this.getStartOffset());
        sb.addProp("length", this.getLength());
        sb.addProp("contents", this.getContents());
        return sb.build();
    }
}

