/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core;

import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ContentLineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.util.TextLineInformationCreator;

@NonNullByDefault
public abstract class LineSequence {
    public static LineSequence create(String text) {
        return new ContentLineSequence(text, new TextLineInformationCreator().create(text));
    }

    public abstract LineSequence lookAhead();

    public LineSequence lookAhead(int lineNumber) {
        LineSequence lookAhead = this.lookAhead();
        Line line = lookAhead.getCurrentLine();
        if (line != null) {
            if (line.getLineNumber() > lineNumber) {
                throw new IllegalArgumentException("lineNumber= " + lineNumber);
            }
            while (line.getLineNumber() < lineNumber) {
                lookAhead.advance();
                line = lookAhead.getCurrentLine();
                if (line != null) continue;
            }
        }
        return lookAhead;
    }

    public abstract @Nullable Line getCurrentLine();

    public abstract @Nullable Line getNextLine();

    public abstract void advance();

    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder(LineSequence.class, this.getClass());
        sb.addProp("currentLine", (Object)this.getCurrentLine());
        sb.addProp("nextLine", (Object)this.getNextLine());
        return sb.build();
    }
}

