/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.base.ui.processing;

import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.statet.docmlet.base.ui.processing.actions.RunDocProcessingOnSaveExtension;
import org.eclipse.statet.docmlet.base.ui.sourceediting.DocEditor;
import org.eclipse.statet.ecommons.ui.actions.AbstractScopeHandler;
import org.eclipse.statet.ecommons.ui.actions.WorkbenchScopingHandler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

@NonNullByDefault
public class ToggleRunOnSaveScopeHandler
extends AbstractScopeHandler
implements IElementUpdater {
    private @Nullable Boolean currentChecked;

    public ToggleRunOnSaveScopeHandler(IWorkbenchWindow scope, @Nullable String commandId) {
        super((Object)scope, commandId);
    }

    protected IWorkbenchWindow getWorkbenchWindow() {
        return (IWorkbenchWindow)ObjectUtils.nonNullAssert((Object)super.getWorkbenchWindow());
    }

    private @Nullable RunDocProcessingOnSaveExtension getSaveExtension() {
        IWorkbenchWindow window = this.getWorkbenchWindow();
        IEditorPart editor = window.getActivePage().getActiveEditor();
        if (editor instanceof DocEditor) {
            return (RunDocProcessingOnSaveExtension)editor.getAdapter(RunDocProcessingOnSaveExtension.class);
        }
        return null;
    }

    private boolean isChecked(@Nullable RunDocProcessingOnSaveExtension saveExtension) {
        return saveExtension != null && saveExtension.isAutoRunEnabled();
    }

    public void setEnabled(IEvaluationContext context) {
        RunDocProcessingOnSaveExtension saveExtension = this.getSaveExtension();
        this.setBaseEnabled(saveExtension != null);
        if (this.currentChecked == null || this.currentChecked.booleanValue() != this.isChecked(saveExtension)) {
            this.refreshCommandElements();
        }
    }

    public void updateCommandElement(UIElement element, Map<String, ?> parameters) {
        RunDocProcessingOnSaveExtension saveExtension = this.getSaveExtension();
        this.currentChecked = this.isChecked(saveExtension);
        element.setChecked(this.currentChecked.booleanValue());
    }

    protected @Nullable Object execute(ExecutionEvent event, IEvaluationContext context) throws ExecutionException {
        RunDocProcessingOnSaveExtension saveExtension = this.getSaveExtension();
        if (saveExtension != null) {
            saveExtension.setAutoRunEnabled(!saveExtension.isAutoRunEnabled());
        }
        return null;
    }

    public static class WorkbenchHandler
    extends WorkbenchScopingHandler
    implements IElementUpdater {
        public WorkbenchHandler() {
            super("org.eclipse.statet.docmlet.commands.ToggleRunDocProcessingOnSave");
        }

        protected AbstractScopeHandler createScopeHandler(Object scope) {
            return new ToggleRunOnSaveScopeHandler((IWorkbenchWindow)scope, this.getCommandId());
        }
    }
}

