/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.processing.actions;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingManager;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingUI;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.jcommons.collections.IdentitySet;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.ResourceUtil;

public class RunDocProcessingOnSaveExtension {
    private final SourceEditor1 editor;
    private boolean isRunEnabled;

    public RunDocProcessingOnSaveExtension(SourceEditor1 editor) {
        this.editor = editor;
    }

    public boolean isAutoRunEnabled() {
        return this.isRunEnabled;
    }

    public void setAutoRunEnabled(boolean enabled) {
        this.isRunEnabled = enabled;
        Map<String, IWorkbenchWindow> filter = Collections.singletonMap("org.eclipse.ui.IWorkbenchWindow", this.editor.getSite().getPage().getWorkbenchWindow());
        WorkbenchUIUtils.refreshCommandElements((String)"org.eclipse.statet.docmlet.commands.ToggleRunDocProcessingOnSave", null, filter);
    }

    public void onEditorSaved() {
        if (this.isAutoRunEnabled()) {
            this.runDocProcessing();
        }
    }

    private void runDocProcessing() {
        IFile file = ResourceUtil.getFile((IEditorInput)this.editor.getEditorInput());
        DocProcessingManager manager = DocProcessingUI.getDocProcessingManager(this.editor.getContentType(), true);
        if (file == null || manager == null) {
            return;
        }
        ILaunchConfiguration config = manager.getActiveConfig();
        if (config != null) {
            manager.launch(config, file, (IdentitySet)DocProcessingUI.CommonFlags.PROCESS_AND_PREVIEW);
        }
    }
}

