/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.shared.common.error;

import java.sql.DataTruncation;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.derby.shared.common.error.ShutdownException;
import org.apache.derby.shared.common.i18n.MessageService;

public class MessageUtils {
    private static final Locale EN = new Locale("en", "US");
    public static final String SQLERRMC_MESSAGE_DELIMITER = new String(new char[]{'\u0014', '\u0014', '\u0014'});
    public static final int DB2_JCC_MAX_EXCEPTION_PARAM_LENGTH = 2400;
    public static String SQLERRMC_TOKEN_DELIMITER = new String(new char[]{'\u0014'});
    private static String SQLERRMC_PREFORMATTED_MESSAGE_DELIMITER = "::";

    protected int supportedMessageParamLength() {
        return 2400;
    }

    public static Object[] getArgs(String sqlState, String sqlerrmc) {
        String messageId = sqlState;
        Object[] arguments = null;
        if (sqlerrmc != null && sqlerrmc.length() > 0) {
            char[] sqlerrmc_chars = sqlerrmc.toCharArray();
            int numArgs = 0;
            int lastSepIdx = -1;
            for (int i = 0; i < sqlerrmc_chars.length; ++i) {
                if (sqlerrmc_chars[i] != '\u0014') continue;
                ++numArgs;
                lastSepIdx = i;
            }
            if (numArgs == 0) {
                messageId = new String(sqlerrmc_chars);
                arguments = new Object[1];
            } else {
                messageId = new String(sqlerrmc_chars, lastSepIdx + 1, sqlerrmc_chars.length - lastSepIdx - 1);
                arguments = new Object[numArgs + 1];
                int start = 0;
                int arg = 0;
                for (int i = 0; i < lastSepIdx + 1; ++i) {
                    if (i != lastSepIdx && sqlerrmc_chars[i] != '\u0014') continue;
                    arguments[arg++] = new String(sqlerrmc_chars, start, i - start);
                    start = i + 1;
                }
            }
            arguments[arguments.length - 1] = messageId;
        } else {
            arguments = new Object[1];
            arguments[arguments.length - 1] = messageId;
        }
        return arguments;
    }

    public static String encodeMessageAndArgumentsAsSqlerrmc(String messageId, Object[] args) {
        Object sqlerrmc = "";
        for (int i = 0; args != null && i < args.length; ++i) {
            sqlerrmc = (String)sqlerrmc + args[i] + SQLERRMC_TOKEN_DELIMITER;
        }
        sqlerrmc = (String)sqlerrmc + messageId;
        return sqlerrmc;
    }

    public static String encodeExceptionAsSqlerrmc(SQLException se) {
        StringBuilder sb = new StringBuilder();
        sb.append(se.getLocalizedMessage());
        se = se.getNextException();
        if (se != null) {
            sb.append(SQLERRMC_TOKEN_DELIMITER);
            sb.append("SQLSTATE: ").append(se.getSQLState());
        }
        return sb.toString();
    }

    private String buildDataTruncationSqlerrmc(DataTruncation dt) {
        return dt.getIndex() + SQLERRMC_TOKEN_DELIMITER + dt.getParameter() + SQLERRMC_TOKEN_DELIMITER + dt.getRead() + SQLERRMC_TOKEN_DELIMITER + dt.getDataSize() + SQLERRMC_TOKEN_DELIMITER + dt.getTransferSize();
    }

    private String buildPreformattedSqlerrmc(SQLException se) {
        if (se == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(se.getLocalizedMessage());
        while ((se = se.getNextException()) != null) {
            sb.append(SQLERRMC_PREFORMATTED_MESSAGE_DELIMITER);
            sb.append("SQLSTATE: ");
            sb.append(se.getSQLState());
        }
        return sb.toString();
    }

    public static int hashString50(String key) {
        int hash = 0;
        int len = key.length();
        if (len > 5) {
            len = 5;
        }
        for (int i = 0; i < len; ++i) {
            hash += key.charAt(i);
        }
        return hash %= 50;
    }

    public static String formatMessage(ResourceBundle bundle, String messageId, Object[] arguments, boolean lastChance) {
        block12: {
            if (arguments == null) {
                arguments = new Object[]{};
            }
            if (bundle != null) {
                try {
                    messageId = bundle.getString(messageId);
                    try {
                        return MessageFormat.format(messageId, arguments);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                }
                catch (MissingResourceException mre) {
                    if (!lastChance) break block12;
                    throw mre;
                }
            }
        }
        if (messageId == null) {
            messageId = "UNKNOWN";
        }
        StringBuffer sb = new StringBuffer(messageId);
        int len = arguments.length;
        if (len > 0) {
            sb.append(" : ");
        }
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append('[');
            sb.append(i);
            sb.append("] ");
            if (arguments[i] == null) {
                sb.append("null");
                continue;
            }
            sb.append(arguments[i].toString());
        }
        return sb.toString();
    }

    public static void getLocalizedMessage(int sqlcode, short errmcLen, String sqlerrmc, String sqlerrp, int errd0, int errd1, int errd2, int errd3, int errd4, int errd5, String warn, String sqlState, String file, String localeStr, String[] msg, int[] rc) {
        int _pos1 = localeStr.indexOf("_");
        Locale locale = EN;
        if (_pos1 != -1) {
            int _pos2 = localeStr.lastIndexOf("_");
            String language = localeStr.substring(0, _pos1);
            if (_pos2 == _pos1) {
                country = localeStr.substring(_pos1 + 1);
                locale = new Locale(language, country);
            } else {
                country = localeStr.substring(_pos1 + 1, _pos2);
                String variant = localeStr.substring(_pos2 + 1);
                locale = new Locale(language, country, variant);
            }
        }
        String messageId = sqlState;
        Object[] args = MessageUtils.getArgs(sqlState, sqlerrmc);
        messageId = (String)args[args.length - 1];
        Object[] arguments = new Object[args.length - 1];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = args[i];
        }
        try {
            msg[0] = MessageUtils.formatMessage(MessageService.getBundleForLocale(locale, messageId), messageId, arguments, true);
            rc[0] = 0;
            return;
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        msg[0] = MessageUtils.formatMessage(MessageService.getBundleForLocale(EN, messageId), messageId, arguments, false);
        rc[0] = 0;
    }

    public static String getLocalizedMessage(Locale locale, String messageId, Object[] args) {
        String locMsg = null;
        try {
            locMsg = MessageUtils.formatMessage(MessageService.getBundleForLocale(locale, messageId), messageId, args, true);
            return locMsg;
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        locMsg = MessageUtils.formatMessage(MessageService.getBundleForLocale(EN, messageId), messageId, args, false);
        return locMsg;
    }
}

