/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.tools.i18n;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.derby.iapi.tools.i18n.LocalizedInput;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.shared.common.i18n.MessageService;

public final class LocalizedResource {
    private ResourceBundle res;
    private Locale locale;
    private String encode;
    public static final String MESSAGE_FILE = "org.apache.derby.loc.tools.toolsmessages";
    public static final String SYSINFO_MESSAGE_FILE = "org.apache.derby.loc.tools.sysinfoMessages";
    public static final String ENV_CODESET = "derby.ui.codeset";
    public static final String ENV_LOCALE = "derby.ui.locale";
    private String messageFileName;
    private String resourceKey;
    private LocalizedOutput out;
    private LocalizedInput in;
    private boolean enableLocalized;
    private static LocalizedResource local;
    private int dateSize;
    private int timeSize;
    private int timestampSize;
    private DateFormat formatDate;
    private DateFormat formatTime;
    private DateFormat formatTimestamp;
    private NumberFormat formatNumber;
    private DecimalFormat formatDecimal;

    private LocalizedResource() {
        this.init();
    }

    public LocalizedResource(String msgF) {
        this.init(null, null, msgF, true);
    }

    public LocalizedResource(String encStr, String locStr, String msgF) {
        this.init(encStr, locStr, msgF, false);
    }

    public static LocalizedResource getInstance() {
        if (local == null) {
            local = new LocalizedResource();
        }
        return local;
    }

    public static void resetLocalizedResourceCache() {
        local = null;
    }

    public void init() {
        this.init(null, null, null);
    }

    public void init(String encStr, String locStr, String msgF) {
        this.init(encStr, locStr, msgF, true);
    }

    private void init(String encStr, String locStr, String msgF, boolean readEnv) {
        String eEncode;
        if (encStr != null) {
            this.encode = encStr;
        }
        if (this.encode == null && readEnv && (eEncode = this.getEnvProperty(ENV_CODESET)) != null) {
            this.encode = eEncode;
        }
        this.locale = this.getNewLocale(locStr);
        if (this.locale == null && readEnv) {
            String s = this.getEnvProperty(ENV_LOCALE);
            this.locale = this.getNewLocale(s);
        }
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        this.messageFileName = msgF != null ? msgF : MESSAGE_FILE;
        this.out = this.getNewOutput(System.out);
        this.in = this.getNewInput(System.in);
        if (this.enableLocalized && this.locale != null) {
            this.formatDecimal = (DecimalFormat)DecimalFormat.getInstance(this.locale);
            this.formatNumber = NumberFormat.getInstance(this.locale);
            this.formatDate = DateFormat.getDateInstance(1, this.locale);
            this.formatTime = DateFormat.getTimeInstance(1, this.locale);
            this.formatTimestamp = DateFormat.getDateTimeInstance(1, 1, this.locale);
        } else {
            this.formatDecimal = (DecimalFormat)DecimalFormat.getInstance();
            this.formatNumber = NumberFormat.getInstance();
            this.formatDate = DateFormat.getDateInstance(1);
            this.formatTime = DateFormat.getTimeInstance(1);
            this.formatTimestamp = DateFormat.getDateTimeInstance(1, 1);
        }
        this.initMaxSizes2();
    }

    private void setResource() {
        if (this.res != null) {
            return;
        }
        this.res = MessageService.getBundleWithEnDefault(this.messageFileName, this.locale);
    }

    private void initMaxSizes2() {
        int len;
        this.dateSize = 0;
        this.timeSize = 0;
        this.timestampSize = 0;
        java.util.Date d = new java.util.Date(60907276800000L);
        Timestamp t = new Timestamp(d.getTime());
        for (int month = 0; month <= 11; ++month) {
            len = this.getDateAsString(d).length();
            if (len > this.dateSize) {
                this.dateSize = len;
            }
            t.setTime(d.getTime() + 79199L);
            len = this.getTimestampAsString(t).length();
            if (len > this.timestampSize) {
                this.timestampSize = len;
            }
            d.setTime(d.getTime() + 2592000000L);
        }
        len = 18;
        for (int hour = 0; hour < 24; ++hour) {
            long secs = (long)hour * 3600L + 3540L + 59L;
            long ms = secs * 1000L;
            java.util.Date td = new java.util.Date(ms);
            String fd = this.formatTime.format(td);
            if (fd.length() <= len) continue;
            len = fd.length();
        }
        this.timeSize = len;
    }

    public LocalizedInput getNewInput(InputStream i) {
        try {
            if (this.encode != null) {
                return new LocalizedInput(i, this.encode);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return new LocalizedInput(i);
    }

    public LocalizedInput getNewEncodedInput(InputStream i, String encoding) {
        try {
            return new LocalizedInput(i, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new LocalizedInput(i);
        }
    }

    public LocalizedOutput getNewOutput(OutputStream o) {
        try {
            if (this.encode != null) {
                return new LocalizedOutput(o, this.encode);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return new LocalizedOutput(o);
    }

    public LocalizedOutput getNewEncodedOutput(OutputStream o, String encoding) throws UnsupportedEncodingException {
        this.out = new LocalizedOutput(o, encoding);
        return this.out;
    }

    private Locale getNewLocale(String locStr) {
        String l = "";
        String r = "";
        String v = "";
        if (locStr == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(locStr, "_");
        try {
            l = st.nextToken();
            if (st.hasMoreTokens()) {
                r = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                v = st.nextToken();
            }
            return new Locale(l, r, v);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getTextMessage(String key, Object ... objectArr) {
        if (this.res == null) {
            this.setResource();
        }
        try {
            return MessageFormat.format(this.res.getString(key), objectArr);
        }
        catch (Exception e) {
            Object tmpFormat = key;
            for (int i = 0; objectArr != null && i < objectArr.length; ++i) {
                tmpFormat = (String)tmpFormat + ", <{" + i + "}>";
            }
            return MessageFormat.format((String)tmpFormat, objectArr);
        }
    }

    public String getLocalizedString(ResultSet rs, ResultSetMetaData rsm, int columnNumber) throws SQLException {
        if (!this.enableLocalized) {
            return rs.getString(columnNumber);
        }
        int type = rsm.getColumnType(columnNumber);
        if (type == 91) {
            return this.getDateAsString(rs.getDate(columnNumber));
        }
        if (type == 4 || type == 5 || type == -5 || type == -6) {
            return this.getNumberAsString(rs.getLong(columnNumber));
        }
        if (type == 7 || type == 6 || type == 8) {
            return this.getNumberAsString(rs.getDouble(columnNumber));
        }
        if (type == 2 || type == 3) {
            return this.getNumberAsString(rs.getBigDecimal(columnNumber));
        }
        if (type == 92) {
            return this.getTimeAsString(rs.getTime(columnNumber));
        }
        if (type == 93) {
            return this.getTimestampAsString(rs.getTimestamp(columnNumber));
        }
        return rs.getString(columnNumber);
    }

    public String getDateAsString(java.util.Date d) {
        if (!this.enableLocalized) {
            return d.toString();
        }
        return this.formatDate.format(d);
    }

    public String getTimeAsString(java.util.Date t) {
        if (!this.enableLocalized) {
            return t.toString();
        }
        return this.formatTime.format(t, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String getNumberAsString(int o) {
        if (this.enableLocalized) {
            return this.formatNumber.format(o);
        }
        return String.valueOf(o);
    }

    public String getNumberAsString(long o) {
        if (this.enableLocalized) {
            return this.formatNumber.format(o);
        }
        return String.valueOf(o);
    }

    public String getNumberAsString(Object o) {
        if (this.enableLocalized) {
            return this.formatNumber.format(o, new StringBuffer(), new FieldPosition(0)).toString();
        }
        return o.toString();
    }

    public String getNumberAsString(double o) {
        if (!this.enableLocalized) {
            return String.valueOf(o);
        }
        return this.formatDecimal.format(o);
    }

    public String getTimestampAsString(Timestamp t) {
        if (!this.enableLocalized) {
            return t.toString();
        }
        return this.formatTimestamp.format(t, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public int getColumnDisplaySize(ResultSetMetaData rsm, int columnNumber) throws SQLException {
        if (!this.enableLocalized) {
            return rsm.getColumnDisplaySize(columnNumber);
        }
        int type = rsm.getColumnType(columnNumber);
        if (type == 91) {
            return this.dateSize;
        }
        if (type == 92) {
            return this.timeSize;
        }
        if (type == 93) {
            return this.timestampSize;
        }
        return rsm.getColumnDisplaySize(columnNumber);
    }

    public String getStringFromDate(String dateStr) throws ParseException {
        if (!this.enableLocalized) {
            return dateStr;
        }
        java.util.Date d = this.formatDate.parse(dateStr);
        return new Date(d.getTime()).toString();
    }

    public String getStringFromTime(String timeStr) throws ParseException {
        if (!this.enableLocalized) {
            return timeStr;
        }
        java.util.Date t = this.formatTime.parse(timeStr);
        return new Time(t.getTime()).toString();
    }

    public String getStringFromValue(String val) throws ParseException {
        if (!this.enableLocalized) {
            return val;
        }
        return this.formatNumber.parse(val).toString();
    }

    public String getStringFromTimestamp(String timestampStr) throws ParseException {
        if (!this.enableLocalized) {
            return timestampStr;
        }
        java.util.Date ts = this.formatTimestamp.parse(timestampStr);
        return new Timestamp(ts.getTime()).toString();
    }

    public Locale getLocale() {
        return this.locale;
    }

    private final synchronized String getEnvProperty(String key) {
        this.resourceKey = key;
        String s = this.run();
        return s;
    }

    public final String run() {
        String s = System.getProperty(this.resourceKey);
        return s;
    }

    public static boolean enableLocalization(boolean mode) {
        LocalizedResource.getInstance().enableLocalized = mode;
        LocalizedResource.getInstance().init();
        return mode;
    }

    public boolean isLocalized() {
        return LocalizedResource.getInstance().enableLocalized;
    }

    public static String getMessage(String key, Object ... args) {
        return LocalizedResource.getInstance().getTextMessage(key, args);
    }

    public static LocalizedOutput OutputWriter() {
        return LocalizedResource.getInstance().out;
    }

    public static LocalizedInput InputReader() {
        return LocalizedResource.getInstance().in;
    }

    public static String getNumber(long o) {
        return LocalizedResource.getInstance().getNumberAsString(o);
    }

    public static String getNumber(int o) {
        return LocalizedResource.getInstance().getNumberAsString(o);
    }

    public String toString() {
        String s = "toString(){\nlocale=" + (this.locale == null ? "null" : this.locale.toString()) + "\nencode=" + this.encode + "\nmessageFile=" + this.messageFileName + "\nresourceKey=" + this.resourceKey + "\nenableLocalized=" + this.enableLocalized + " \ndateSize=" + this.dateSize + "\ntimeSize=" + this.timeSize + "\ntimestampSize=" + this.timestampSize + "\n}";
        return s;
    }
}

