/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ReadListener;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestAttributeEvent;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import jakarta.servlet.http.PushBuilder;
import jakarta.servlet.http.WebConnection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.eclipse.jetty.ee10.servlet.AsyncContextEvent;
import org.eclipse.jetty.ee10.servlet.AsyncContextState;
import org.eclipse.jetty.ee10.servlet.PushBuilderImpl;
import org.eclipse.jetty.ee10.servlet.ServletChannel;
import org.eclipse.jetty.ee10.servlet.ServletChannelState;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextResponse;
import org.eclipse.jetty.ee10.servlet.ServletCoreResponse;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.ee10.servlet.ServletMultiPartFormData;
import org.eclipse.jetty.ee10.servlet.ServletPathMapping;
import org.eclipse.jetty.ee10.servlet.util.ServletInputStreamWrapper;
import org.eclipse.jetty.ee10.servlet.util.ServletOutputStreamWrapper;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.SetCookieParser;
import org.eclipse.jetty.http.pathmap.MatchedResource;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.QuietException;
import org.eclipse.jetty.security.AuthenticationState;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.CookieCache;
import org.eclipse.jetty.server.FormFields;
import org.eclipse.jetty.server.HttpCookieUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.session.AbstractSessionManager;
import org.eclipse.jetty.session.SessionManager;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletApiRequest
implements HttpServletRequest {
    private static final Logger LOG = LoggerFactory.getLogger(ServletApiRequest.class);
    private static final SetCookieParser SET_COOKIE_PARSER = SetCookieParser.newInstance();
    private final ServletContextRequest _servletContextRequest;
    private final ServletChannel _servletChannel;
    private AsyncContextState _async;
    private Charset _charset;
    private Charset _readerCharset;
    private int _inputState = 0;
    private BufferedReader _reader;
    private String _contentType;
    protected Fields _contentParameters;
    private Fields _parameters;
    protected Fields _queryParameters;
    private ServletMultiPartFormData.Parts _parts;
    private boolean _asyncSupported = true;

    protected ServletApiRequest(ServletContextRequest servletContextRequest) {
        this._servletContextRequest = servletContextRequest;
        this._servletChannel = this._servletContextRequest.getServletChannel();
    }

    @Deprecated(since="12.0.24", forRemoval=true)
    public AuthenticationState getAuthentication() {
        return this.getAuthenticationState();
    }

    public AuthenticationState getAuthenticationState() {
        return AuthenticationState.getAuthenticationState((Request)this.getRequest());
    }

    private AuthenticationState getUndeferredAuthenticationState() {
        AuthenticationState.Deferred deferred;
        AuthenticationState.Succeeded undeferred;
        AuthenticationState authenticationState = this.getAuthentication();
        if (authenticationState instanceof AuthenticationState.Deferred && (undeferred = (deferred = (AuthenticationState.Deferred)authenticationState).authenticate(this.getRequest())) != null) {
            authenticationState = undeferred;
        }
        return authenticationState;
    }

    private AuthenticationState getUndeferredAuthenticationState(HttpServletResponse response) throws IOException {
        AuthenticationState authenticationState = this.getAuthentication();
        if (authenticationState instanceof AuthenticationState.Deferred) {
            AuthenticationState undeferred;
            AuthenticationState.Deferred deferred = (AuthenticationState.Deferred)authenticationState;
            try (Blocker.Callback callback = Blocker.callback();){
                Response wrappedCoreResponse = ServletCoreResponse.wrap(this.getRequest(), response, false);
                undeferred = deferred.authenticate(this.getRequest(), wrappedCoreResponse, (Callback)callback);
                if (undeferred instanceof AuthenticationState.ResponseSent) {
                    callback.block();
                } else {
                    callback.succeeded();
                }
            }
            if (undeferred != null) {
                authenticationState = undeferred;
            }
        }
        return authenticationState;
    }

    public String getMethod() {
        return this.getRequest().getMethod();
    }

    public ServletContextHandler.ServletRequestInfo getServletRequestInfo() {
        return this._servletContextRequest;
    }

    public Request getRequest() {
        ServletChannel servletChannel = this._servletChannel;
        return servletChannel == null ? this._servletContextRequest : servletChannel.getRequest();
    }

    public HttpFields getFields() {
        return this.getRequest().getHeaders();
    }

    public String getRequestId() {
        return this.getRequest().getConnectionMetaData().getId() + "#" + this.getRequest().getId();
    }

    public String getProtocolRequestId() {
        return switch (this.getRequest().getConnectionMetaData().getHttpVersion()) {
            case HttpVersion.HTTP_2, HttpVersion.HTTP_3 -> this.getRequest().getId();
            default -> "";
        };
    }

    public ServletConnection getServletConnection() {
        final ConnectionMetaData connectionMetaData = this.getRequest().getConnectionMetaData();
        return new ServletConnection(){
            final /* synthetic */ ServletApiRequest this$0;
            {
                this.this$0 = this$0;
            }

            public String getConnectionId() {
                return connectionMetaData.getId();
            }

            public String getProtocol() {
                return connectionMetaData.getProtocol();
            }

            public String getProtocolConnectionId() {
                if (HttpVersion.HTTP_3.is(connectionMetaData.getProtocol())) {
                    return connectionMetaData.getId();
                }
                return "";
            }

            public boolean isSecure() {
                return connectionMetaData.isSecure();
            }
        };
    }

    public String getAuthType() {
        AuthenticationState authenticationState = this.getUndeferredAuthenticationState();
        if (authenticationState instanceof AuthenticationState.Succeeded) {
            AuthenticationState.Succeeded succeededAuthentication = (AuthenticationState.Succeeded)authenticationState;
            return succeededAuthentication.getAuthenticationType();
        }
        return null;
    }

    public Cookie[] getCookies() {
        return (Cookie[])CookieCache.getApiCookies((Request)this.getRequest(), Cookie.class, this::convertCookie);
    }

    private Cookie convertCookie(HttpCookie cookie) {
        CookieCompliance compliance = this.getRequest().getConnectionMetaData().getHttpConfiguration().getRequestCookieCompliance();
        Cookie result = new Cookie(cookie.getName(), cookie.getValue());
        if (CookieCompliance.RFC2965.equals(compliance)) {
            result.setPath(cookie.getPath());
            result.setDomain(cookie.getDomain());
        }
        return result;
    }

    public long getDateHeader(String name) {
        HttpFields fields = this.getFields();
        if (fields == null) {
            return -1L;
        }
        HttpField field = fields.getField(name);
        if (field == null) {
            return -1L;
        }
        long date = fields.getDateField(name);
        if (date == -1L) {
            throw new IllegalArgumentException("Cannot parse date");
        }
        return date;
    }

    public String getHeader(String name) {
        return this.getFields().get(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return this.getFields().getValues(name);
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.getFields().getFieldNamesCollection());
    }

    public int getIntHeader(String name) {
        HttpFields fields = this.getFields();
        return fields == null ? -1 : (int)fields.getLongField(name);
    }

    public String getPathInfo() {
        return this.getServletRequestInfo().getMatchedResource().getMatchedPath().getPathInfo();
    }

    public String getPathTranslated() {
        String pathInfo = this.getPathInfo();
        if (pathInfo == null || this.getServletRequestInfo().getServletContext() == null) {
            return null;
        }
        return this.getServletRequestInfo().getServletContext().getServletContext().getRealPath(pathInfo);
    }

    public String getContextPath() {
        return this.getServletRequestInfo().getServletContext().getServletContextHandler().getRequestContextPath();
    }

    public String getQueryString() {
        return this.getRequest().getHttpURI().getQuery();
    }

    public String getRemoteUser() {
        Principal p = this.getUserPrincipal();
        if (p == null) {
            return null;
        }
        return p.getName();
    }

    public boolean isUserInRole(String role) {
        String linkedRole = ((ServletHandler.MappedServlet)this.getServletRequestInfo().getMatchedResource().getResource()).getServletHolder().getUserRoleLink(role);
        AuthenticationState authenticationState = this.getUndeferredAuthenticationState();
        if (authenticationState instanceof AuthenticationState.Succeeded) {
            AuthenticationState.Succeeded succeededAuthentication = (AuthenticationState.Succeeded)authenticationState;
            return succeededAuthentication.isUserInRole(linkedRole);
        }
        return false;
    }

    public Principal getUserPrincipal() {
        AuthenticationState authenticationState = this.getUndeferredAuthenticationState();
        if (authenticationState instanceof AuthenticationState.Succeeded) {
            AuthenticationState.Succeeded succeededAuthentication = (AuthenticationState.Succeeded)authenticationState;
            UserIdentity user = succeededAuthentication.getUserIdentity();
            return user.getUserPrincipal();
        }
        return null;
    }

    public String getRequestedSessionId() {
        AbstractSessionManager.RequestedSession requestedSession = this.getServletRequestInfo().getRequestedSession();
        return requestedSession == null ? null : requestedSession.sessionId();
    }

    public String getRequestURI() {
        HttpURI uri = this.getRequest().getHttpURI();
        return uri == null ? null : uri.getPath();
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(HttpURI.build((HttpURI)this.getRequest().getHttpURI()).query(null).asString());
    }

    public String getServletPath() {
        return this.getServletRequestInfo().getMatchedResource().getMatchedPath().getPathMatch();
    }

    public HttpSession getSession(boolean create) {
        Session session = this.getRequest().getSession(create);
        if (session == null) {
            return null;
        }
        if (session.isNew() && this.getAuthentication() instanceof AuthenticationState.Succeeded) {
            session.setAttribute("org.eclipse.jetty.security.sessionCreatedSecure", (Object)Boolean.TRUE);
        }
        return (HttpSession)session.getApi();
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public String changeSessionId() {
        Session session = this.getRequest().getSession(false);
        if (session == null) {
            throw new IllegalStateException("No session");
        }
        session.renewId(this.getRequest(), this._servletChannel.getResponse());
        if (this.getRemoteUser() != null) {
            session.setAttribute("org.eclipse.jetty.security.sessionCreatedSecure", (Object)Boolean.TRUE);
        }
        return session.getId();
    }

    public boolean isRequestedSessionIdValid() {
        AbstractSessionManager.RequestedSession requestedSession = this.getServletRequestInfo().getRequestedSession();
        HttpSession session = this.getSession(false);
        SessionManager manager = this.getServletRequestInfo().getSessionManager();
        return requestedSession != null && requestedSession.sessionId() != null && requestedSession.session() != null && requestedSession.session().isValid() && manager != null && manager.getSessionIdManager().getId(requestedSession.sessionId()).equals(session.getId());
    }

    public boolean isRequestedSessionIdFromCookie() {
        AbstractSessionManager.RequestedSession requestedSession = this.getServletRequestInfo().getRequestedSession();
        return requestedSession != null && requestedSession.sessionId() != null && requestedSession.isSessionIdFrom("cookie");
    }

    public boolean isRequestedSessionIdFromURL() {
        AbstractSessionManager.RequestedSession requestedSession = this.getServletRequestInfo().getRequestedSession();
        return requestedSession != null && requestedSession.sessionId() != null && requestedSession.isSessionIdFrom("uri");
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        if (this.getUserPrincipal() != null && this.getRemoteUser() != null && this.getAuthType() != null) {
            return true;
        }
        AuthenticationState authenticationState = this.getUndeferredAuthenticationState(response);
        if (authenticationState instanceof AuthenticationState.ResponseSent) {
            return false;
        }
        throw new ServletException("Authentication failed");
    }

    public void login(String username, String password) throws ServletException {
        try {
            ServletContextHandler.ServletRequestInfo servletRequestInfo = this.getServletRequestInfo();
            AuthenticationState.Succeeded succeededAuthentication = AuthenticationState.login((String)username, (String)password, (Request)this.getRequest(), (Response)servletRequestInfo.getServletChannel().getServletContextResponse());
            if (succeededAuthentication == null) {
                throw new QuietException.Exception("Authentication failed for username '" + username + "'");
            }
        }
        catch (Throwable t) {
            throw new ServletException(t.getMessage(), t);
        }
    }

    public void logout() throws ServletException {
        ServletContextHandler.ServletRequestInfo servletRequestInfo = this.getServletRequestInfo();
        if (!AuthenticationState.logout((Request)this.getRequest(), (Response)servletRequestInfo.getServletChannel().getServletContextResponse())) {
            throw new ServletException("logout failed");
        }
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        if (this._parts == null) {
            try {
                this._parts = ServletMultiPartFormData.getParts((ServletRequest)this);
                Collection<Part> parts = this._parts.getParts();
                String formCharset = null;
                Part charsetPart = this._parts.getPart("_charset_");
                if (charsetPart != null) {
                    try (InputStream is = charsetPart.getInputStream();){
                        formCharset = IO.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    }
                }
                Charset defaultCharset = formCharset != null ? Charset.forName(formCharset) : (this.getCharacterEncoding() != null ? Charset.forName(this.getCharacterEncoding()) : StandardCharsets.UTF_8);
                ServletContextHandler servletContextHandler = this.getServletRequestInfo().getServletContext().getServletContextHandler();
                long maxFormContentSize = servletContextHandler.getMaxFormContentSize();
                int maxFormKeys = servletContextHandler.getMaxFormKeys();
                long formContentSize = 0L;
                int count = 0;
                for (Part p : parts) {
                    if (maxFormKeys > 0 && ++count > maxFormKeys) {
                        throw new IllegalStateException("Too many form keys > " + maxFormKeys);
                    }
                    if (p.getSubmittedFileName() != null) continue;
                    formContentSize = Math.addExact(formContentSize, p.getSize());
                    if (maxFormContentSize >= 0L && formContentSize > maxFormContentSize) {
                        throw new IllegalStateException("Form is larger than max length " + maxFormContentSize);
                    }
                    String charset = null;
                    if (p.getContentType() != null) {
                        charset = MimeTypes.getCharsetFromContentType((String)p.getContentType());
                    }
                    InputStream is = p.getInputStream();
                    try {
                        String content = IO.toString((InputStream)is, (Charset)(charset == null ? defaultCharset : Charset.forName(charset)));
                        if (this._contentParameters == null || this._contentParameters.isEmpty()) {
                            this._contentParameters = new Fields(true);
                        }
                        this._contentParameters.add(p.getName(), content);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
            }
            catch (Throwable t) {
                Throwable cause;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getParts", t);
                }
                if (t instanceof ExecutionException) {
                    ExecutionException ee = (ExecutionException)t;
                    cause = ee.getCause();
                } else if (t instanceof ServletException) {
                    ServletException se = (ServletException)t;
                    cause = se.getCause();
                } else {
                    cause = t;
                }
                if (cause instanceof IOException) {
                    IOException ioException = (IOException)cause;
                    throw ioException;
                }
                throw new ServletException((Throwable)new BadMessageException("bad multipart", cause));
            }
        }
        return this._parts.getParts();
    }

    public Part getPart(String name) throws IOException, ServletException {
        this.getParts();
        return this._parts.getPart(name);
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        HttpUpgradeHandler upgradeHandler;
        ServletContextResponse response = this._servletContextRequest.getServletContextResponse();
        if (response.getStatus() != 101) {
            throw new IllegalStateException("Response status should be 101");
        }
        if (response.getHeaders().get("Upgrade") == null) {
            throw new IllegalStateException("Missing Upgrade header");
        }
        if (!"Upgrade".equalsIgnoreCase(response.getHeaders().get("Connection"))) {
            throw new IllegalStateException("Invalid Connection header");
        }
        if (response.isCommitted()) {
            throw new IllegalStateException("Cannot upgrade committed response");
        }
        if (this._servletChannel.getConnectionMetaData().getHttpVersion() != HttpVersion.HTTP_1_1) {
            throw new IllegalStateException("Only requests over HTTP/1.1 can be upgraded");
        }
        final CompletableFuture outputStreamComplete = new CompletableFuture();
        final CompletableFuture inputStreamComplete = new CompletableFuture();
        final ServletOutputStreamWrapper outputStream = new ServletOutputStreamWrapper(this, this._servletContextRequest.getHttpOutput()){
            final /* synthetic */ ServletApiRequest this$0;
            {
                this.this$0 = this$0;
                super(outputStream);
            }

            @Override
            public void write(int b) throws IOException {
                try {
                    super.write(b);
                }
                catch (Throwable t) {
                    outputStreamComplete.completeExceptionally(t);
                    throw t;
                }
            }

            @Override
            public void write(byte[] b) throws IOException {
                try {
                    super.write(b);
                }
                catch (Throwable t) {
                    outputStreamComplete.completeExceptionally(t);
                    throw t;
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                try {
                    super.write(b, off, len);
                }
                catch (Throwable t) {
                    outputStreamComplete.completeExceptionally(t);
                    throw t;
                }
            }

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                    outputStreamComplete.complete(null);
                }
                catch (Throwable t) {
                    outputStreamComplete.completeExceptionally(t);
                    throw t;
                }
            }

            @Override
            public void setWriteListener(final WriteListener writeListener) {
                super.setWriteListener(new WriteListener(){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void onWritePossible() throws IOException {
                        writeListener.onWritePossible();
                    }

                    public void onError(Throwable t) {
                        writeListener.onError(t);
                        this.this$1.outputStreamComplete.completeExceptionally(t);
                    }
                });
            }
        };
        final ServletInputStreamWrapper inputStream = new ServletInputStreamWrapper(this, this._servletContextRequest.getHttpInput()){
            final /* synthetic */ ServletApiRequest this$0;
            {
                this.this$0 = this$0;
                super(servletInputStream);
            }

            @Override
            public int read() throws IOException {
                try {
                    int read = super.read();
                    if (read == -1) {
                        inputStreamComplete.complete(null);
                    }
                    return read;
                }
                catch (Throwable t) {
                    inputStreamComplete.completeExceptionally(t);
                    throw t;
                }
            }

            @Override
            public int read(byte[] b) throws IOException {
                try {
                    int read = super.read(b);
                    if (read == -1) {
                        inputStreamComplete.complete(null);
                    }
                    return read;
                }
                catch (Throwable t) {
                    inputStreamComplete.completeExceptionally(t);
                    throw t;
                }
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                try {
                    int read = super.read(b, off, len);
                    if (read == -1) {
                        inputStreamComplete.complete(null);
                    }
                    return read;
                }
                catch (Throwable t) {
                    inputStreamComplete.completeExceptionally(t);
                    throw t;
                }
            }

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                    inputStreamComplete.complete(null);
                }
                catch (Throwable t) {
                    inputStreamComplete.completeExceptionally(t);
                    throw t;
                }
            }

            @Override
            public void setReadListener(final ReadListener readListener) {
                super.setReadListener(new ReadListener(){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void onDataAvailable() throws IOException {
                        readListener.onDataAvailable();
                    }

                    public void onAllDataRead() throws IOException {
                        try {
                            readListener.onAllDataRead();
                            this.this$1.inputStreamComplete.complete(null);
                        }
                        catch (Throwable t) {
                            this.this$1.inputStreamComplete.completeExceptionally(t);
                            throw t;
                        }
                    }

                    public void onError(Throwable t) {
                        readListener.onError(t);
                        this.this$1.inputStreamComplete.completeExceptionally(t);
                    }
                });
            }
        };
        try {
            upgradeHandler = (HttpUpgradeHandler)handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ServletException("Unable to instantiate handler class", (Throwable)e);
        }
        Connection connection = this._servletContextRequest.getConnectionMetaData().getConnection();
        if (!(connection instanceof Connection.Tunnel)) {
            LOG.warn("Unexpected connection type {}", (Object)connection);
            throw new IllegalStateException();
        }
        Connection.Tunnel upgradeableConnection = (Connection.Tunnel)connection;
        outputStream.flush();
        upgradeableConnection.startTunnel();
        AsyncContext asyncContext = this.forceStartAsync();
        CompletableFuture.allOf(inputStreamComplete, outputStreamComplete).whenComplete((result, failure) -> {
            upgradeHandler.destroy();
            asyncContext.complete();
        });
        WebConnection webConnection = new WebConnection(){
            final /* synthetic */ ServletApiRequest this$0;
            {
                this.this$0 = this$0;
            }

            public void close() throws Exception {
                IO.close((InputStream)inputStream);
                IO.close((OutputStream)outputStream);
            }

            public ServletInputStream getInputStream() {
                return inputStream;
            }

            public ServletOutputStream getOutputStream() {
                return outputStream;
            }
        };
        upgradeHandler.init(webConnection);
        return (T)upgradeHandler;
    }

    public PushBuilder newPushBuilder() {
        String sessionId;
        HttpSession httpSession;
        if (!this.getRequest().getConnectionMetaData().isPushSupported()) {
            return null;
        }
        HttpFields.Mutable pushHeaders = HttpFields.build((HttpFields)this.getRequest().getHeaders(), EnumSet.of(HttpHeader.IF_MATCH, new HttpHeader[]{HttpHeader.IF_RANGE, HttpHeader.IF_UNMODIFIED_SINCE, HttpHeader.RANGE, HttpHeader.EXPECT, HttpHeader.IF_NONE_MATCH, HttpHeader.IF_MODIFIED_SINCE}));
        Object referrer = this.getRequestURL().toString();
        String query = this.getQueryString();
        if (query != null) {
            referrer = (String)referrer + "?" + query;
        }
        pushHeaders.put(HttpHeader.REFERER, (String)referrer);
        Cookie[] existing = this.getCookies();
        ArrayList<Object> cookies = new ArrayList<Object>();
        if (existing != null && existing.length > 0) {
            cookies.addAll(Arrays.asList(existing));
        }
        for (Object field : this._servletContextRequest.getServletContextResponse().getHeaders()) {
            HttpCookie httpCookie;
            HttpCookie httpCookie2;
            HttpHeader httpHeader = field.getHeader();
            if (httpHeader != HttpHeader.SET_COOKIE && httpHeader != HttpHeader.SET_COOKIE2) continue;
            if (field instanceof HttpCookieUtils.SetCookieHttpField) {
                HttpCookieUtils.SetCookieHttpField set = (HttpCookieUtils.SetCookieHttpField)field;
                httpCookie2 = set.getHttpCookie();
            } else {
                httpCookie2 = SET_COOKIE_PARSER.parse(field.getValue());
            }
            if ((httpCookie = httpCookie2) == null) continue;
            if (httpCookie.isExpired()) {
                Iterator i = cookies.iterator();
                while (i.hasNext()) {
                    HttpCookie cookie;
                    Cookie cookie2;
                    Object o = i.next();
                    if (o instanceof Cookie && (cookie2 = (Cookie)o).getName().equals(httpCookie.getName())) {
                        i.remove();
                        continue;
                    }
                    if (!(o instanceof HttpCookie) || !(cookie = (HttpCookie)o).getName().equals(httpCookie.getName())) continue;
                    i.remove();
                }
                continue;
            }
            cookies.add(httpCookie);
        }
        if (!cookies.isEmpty()) {
            StringBuilder cookieBuilder = new StringBuilder();
            for (Object e : cookies) {
                if (!cookieBuilder.isEmpty()) {
                    cookieBuilder.append("; ");
                }
                if (e instanceof Cookie) {
                    Cookie cookie = (Cookie)e;
                    cookieBuilder.append(cookie.getName()).append("=").append(cookie.getValue());
                    continue;
                }
                if (!(e instanceof HttpCookie)) continue;
                HttpCookie httpCookie = (HttpCookie)e;
                cookieBuilder.append(httpCookie.getName()).append("=").append(httpCookie.getValue());
            }
            pushHeaders.put(HttpHeader.COOKIE, cookieBuilder.toString());
        }
        if ((httpSession = this.getSession(false)) != null) {
            try {
                httpSession.getLastAccessedTime();
                sessionId = httpSession.getId();
            }
            catch (Throwable throwable) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("invalid HTTP session", throwable);
                }
                sessionId = this.getRequestedSessionId();
            }
        } else {
            sessionId = this.getRequestedSessionId();
        }
        return new PushBuilderImpl(ServletContextRequest.getServletContextRequest((ServletRequest)this), pushHeaders, sessionId);
    }

    public Object getAttribute(String name) {
        if (this._async != null) {
            return switch (name) {
                case "jakarta.servlet.async.request_uri" -> this.getRequestURI();
                case "jakarta.servlet.async.context_path" -> this.getContextPath();
                case "jakarta.servlet.async.servlet_path" -> this.getServletPath();
                case "jakarta.servlet.async.path_info" -> this.getPathInfo();
                case "jakarta.servlet.async.query_string" -> this.getQueryString();
                case "jakarta.servlet.async.mapping" -> this.getHttpServletMapping();
                default -> this.getRequest().getAttribute(name);
            };
        }
        return this.getRequest().getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        HashSet<String> set = this.getRequest().getAttributeNameSet();
        if (this._async != null) {
            set = new HashSet<String>(set);
            set.add("jakarta.servlet.async.request_uri");
            set.add("jakarta.servlet.async.context_path");
            set.add("jakarta.servlet.async.servlet_path");
            set.add("jakarta.servlet.async.path_info");
            set.add("jakarta.servlet.async.query_string");
            set.add("jakarta.servlet.async.mapping");
        }
        return Collections.enumeration(set);
    }

    public String getCharacterEncoding() {
        try {
            if (this._charset == null) {
                this._charset = Request.getCharset((Request)this.getRequest());
            }
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            return MimeTypes.getCharsetFromContentType((String)this.getRequest().getHeaders().get(HttpHeader.CONTENT_TYPE));
        }
        if (this._charset == null) {
            return this.getServletRequestInfo().getServletContext().getServletContext().getRequestCharacterEncoding();
        }
        return this._charset.name();
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this._inputState != 0) {
            return;
        }
        this._charset = MimeTypes.getKnownCharset((String)encoding);
    }

    public int getContentLength() {
        long contentLength = this.getContentLengthLong();
        if (contentLength > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)contentLength;
    }

    public long getContentLengthLong() {
        if (this.getFields() == null) {
            return -1L;
        }
        return this.getFields().getLongField(HttpHeader.CONTENT_LENGTH);
    }

    public String getContentType() {
        HttpField contentType;
        if (this._contentType == null && (contentType = this.getFields().getField(HttpHeader.CONTENT_TYPE)) != null) {
            this._contentType = contentType.getValue();
            if (this._charset == null) {
                this._charset = MimeTypes.getCharsetFromContentType((HttpField)contentType);
            }
        }
        return this._contentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._inputState != 0 && this._inputState != 1) {
            throw new IllegalStateException("READER");
        }
        if (this._inputState == 0 && this._servletContextRequest.getHeaders().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString())) {
            this._servletChannel.getResponse().writeInterim(100, HttpFields.EMPTY);
        }
        this._inputState = 1;
        return this.getServletRequestInfo().getHttpInput();
    }

    public String getParameter(String name) {
        return this.getParameters().getValue(name);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameters().getNames());
    }

    public String[] getParameterValues(String name) {
        List vals = this.getParameters().getValues(name);
        if (vals == null) {
            return null;
        }
        return vals.toArray(new String[0]);
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.getParameters().toStringArrayMap());
    }

    public Fields getParameters() {
        Fields parameters = this._parameters;
        if (parameters == null) {
            this.extractContentParameters();
            this.extractQueryParameters();
            if (ServletContextRequest.isNoParams(this._queryParameters) || this._queryParameters.getSize() == 0) {
                this._parameters = this._contentParameters;
            } else if (ServletContextRequest.isNoParams(this._contentParameters) || this._contentParameters.getSize() == 0) {
                this._parameters = this._queryParameters;
            } else if (this._parameters == null) {
                this._parameters = new Fields(true);
                this._parameters.addAll(this._queryParameters);
                this._parameters.addAll(this._contentParameters);
            }
            parameters = this._parameters;
        }
        return parameters == null ? ServletContextRequest.NO_PARAMS : parameters;
    }

    private void extractContentParameters() throws BadMessageException {
        if (this._contentParameters == null) {
            try {
                int contentLength = this.getContentLength();
                if (contentLength != 0) {
                    String baseType = HttpField.getValueParameters((String)this.getContentType(), null);
                    if (MimeTypes.Type.FORM_ENCODED.is(baseType) && this.getRequest().getConnectionMetaData().getHttpConfiguration().isFormEncodedMethod(this.getMethod())) {
                        try {
                            ServletContextHandler contextHandler = this.getServletRequestInfo().getServletContextHandler();
                            int maxKeys = contextHandler.getMaxFormKeys();
                            int maxContentSize = contextHandler.getMaxFormContentSize();
                            this._contentParameters = FormFields.getFields((Request)this.getRequest(), (int)maxKeys, (int)maxContentSize);
                        }
                        catch (IllegalArgumentException | IllegalStateException | CompletionException e) {
                            throw new BadMessageException("Unable to parse form content", (Throwable)e);
                        }
                    }
                    if (MimeTypes.Type.MULTIPART_FORM_DATA.is(baseType) && this.getAttribute("org.eclipse.jetty.multipartConfig") != null) {
                        try {
                            this.getParts();
                        }
                        catch (IOException e) {
                            String msg = "Unable to extract content parameters";
                            if (LOG.isDebugEnabled()) {
                                LOG.debug(msg, (Throwable)e);
                            }
                            throw new UncheckedIOException(msg, e);
                        }
                        catch (ServletException e) {
                            Throwable cause = e.getCause();
                            if (cause instanceof BadMessageException) {
                                BadMessageException badMessageException = (BadMessageException)cause;
                                throw badMessageException;
                            }
                            String msg = "Unable to extract content parameters";
                            if (LOG.isDebugEnabled()) {
                                LOG.debug(msg, (Throwable)e);
                            }
                            if (cause instanceof IOException) {
                                IOException ioe = (IOException)cause;
                                throw new UncheckedIOException(msg, ioe);
                            }
                            throw new RuntimeException(msg, e);
                        }
                    }
                    try {
                        this._contentParameters = FormFields.getFields((Request)this.getRequest());
                    }
                    catch (IllegalArgumentException | IllegalStateException | CompletionException e) {
                        throw new BadMessageException("Unable to parse form content", (Throwable)e);
                    }
                }
                if (this._contentParameters == null || this._contentParameters.isEmpty()) {
                    this._contentParameters = ServletContextRequest.NO_PARAMS;
                }
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                throw new BadMessageException("Unable to parse form content", (Throwable)e);
            }
        }
    }

    protected void extractQueryParameters() throws BadMessageException {
        if (this._queryParameters == null) {
            HttpURI httpURI = this.getRequest().getHttpURI();
            if (httpURI == null || StringUtil.isEmpty((String)httpURI.getQuery())) {
                this._queryParameters = ServletContextRequest.NO_PARAMS;
            } else {
                try {
                    this._queryParameters = Request.extractQueryParameters((Request)this.getRequest(), (Charset)this.getServletRequestInfo().getQueryEncoding());
                }
                catch (IllegalArgumentException | IllegalStateException e) {
                    this._queryParameters = ServletContextRequest.BAD_PARAMS;
                    throw new BadMessageException("Unable to parse URI query", (Throwable)e);
                }
            }
        }
    }

    public String getProtocol() {
        return this.getRequest().getConnectionMetaData().getProtocol();
    }

    public String getScheme() {
        return this.getRequest().getHttpURI().getScheme();
    }

    public String getServerName() {
        HttpURI uri = this.getRequest().getHttpURI();
        if (uri != null && StringUtil.isNotBlank((String)uri.getAuthority())) {
            return this.formatAddrOrHost(uri.getHost());
        }
        return this.findServerName();
    }

    private String formatAddrOrHost(String name) {
        ServletChannel servletChannel = this._servletChannel;
        return servletChannel == null ? HostPort.normalizeHost((String)name) : servletChannel.formatAddrOrHost(name);
    }

    private String findServerName() {
        HostPort serverAuthority;
        ServletChannel servletChannel = this._servletChannel;
        if (servletChannel != null && (serverAuthority = servletChannel.getServerAuthority()) != null) {
            return this.formatAddrOrHost(serverAuthority.getHost());
        }
        String name = this.getLocalName();
        if (name != null) {
            return this.formatAddrOrHost(name);
        }
        return "";
    }

    public int getServerPort() {
        HttpURI uri = this.getRequest().getHttpURI();
        int port = uri != null && StringUtil.isNotBlank((String)uri.getAuthority()) ? uri.getPort() : this.findServerPort();
        if (port <= 0) {
            return URIUtil.getDefaultPortForScheme((String)this.getScheme());
        }
        return port;
    }

    private int findServerPort() {
        HostPort serverAuthority;
        ServletChannel servletChannel = this.getServletRequestInfo().getServletChannel();
        if (servletChannel != null && (serverAuthority = servletChannel.getServerAuthority()) != null) {
            return serverAuthority.getPort();
        }
        return this.getLocalPort();
    }

    public BufferedReader getReader() throws IOException {
        if (this._inputState != 0 && this._inputState != 2) {
            throw new IllegalStateException("STREAMED");
        }
        if (this._inputState == 2) {
            return this._reader;
        }
        Charset charset = this._charset;
        try {
            if (charset == null && (charset = (this._charset = Request.getCharset((Request)this.getRequest()))) == null) {
                charset = StandardCharsets.ISO_8859_1;
            }
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException(this, e.getMessage()){
                final /* synthetic */ ServletApiRequest this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.initCause(e);
                }

                @Override
                public String toString() {
                    return "%s@%x:%s".formatted(UnsupportedEncodingException.class.getName(), this.hashCode(), this.getMessage());
                }
            };
        }
        if (this._reader != null && charset.equals(this._readerCharset)) {
            if (this._inputState == 0 && this._servletContextRequest.getHeaders().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString())) {
                this._servletChannel.getResponse().writeInterim(100, HttpFields.EMPTY);
            }
        } else {
            final ServletInputStream in = this.getInputStream();
            this._readerCharset = charset;
            this._reader = new BufferedReader(this, new InputStreamReader((InputStream)in, charset)){
                final /* synthetic */ ServletApiRequest this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void close() throws IOException {
                    in.close();
                }
            };
        }
        this._inputState = 2;
        return this._reader;
    }

    public String getRemoteAddr() {
        return Request.getRemoteAddr((Request)this.getRequest());
    }

    public String getRemoteHost() {
        return Request.getRemoteAddr((Request)this.getRequest());
    }

    public void setAttribute(String name, Object attribute) {
        Object oldValue = this.getRequest().setAttribute(name, attribute);
        if ("org.eclipse.jetty.server.Request.queryEncoding".equals(name)) {
            this.getServletRequestInfo().setQueryEncoding(attribute == null ? null : attribute.toString());
        }
        if (!this.getServletRequestInfo().getRequestAttributeListeners().isEmpty()) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)this.getServletRequestInfo().getServletContext().getServletContext(), (ServletRequest)this, name, oldValue == null ? attribute : oldValue);
            for (ServletRequestAttributeListener l : this.getServletRequestInfo().getRequestAttributeListeners()) {
                if (oldValue == null) {
                    l.attributeAdded(event);
                    continue;
                }
                if (attribute == null) {
                    l.attributeRemoved(event);
                    continue;
                }
                l.attributeReplaced(event);
            }
        }
    }

    public void removeAttribute(String name) {
        Object oldValue = this.getRequest().removeAttribute(name);
        if (oldValue != null && !this.getServletRequestInfo().getRequestAttributeListeners().isEmpty()) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)this.getServletRequestInfo().getServletContext().getServletContext(), (ServletRequest)this, name, oldValue);
            for (ServletRequestAttributeListener listener : this.getServletRequestInfo().getRequestAttributeListeners()) {
                listener.attributeRemoved(event);
            }
        }
    }

    public Locale getLocale() {
        return (Locale)Request.getLocales((Request)this.getRequest()).get(0);
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(Request.getLocales((Request)this.getRequest()));
    }

    public boolean isSecure() {
        return this.getRequest().isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        ServletContextHandler.ServletScopedContext context = this.getServletRequestInfo().getServletContext();
        if (path == null || context == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            String relTo = this.getServletRequestInfo().getDecodedPathInContext();
            int slash = relTo.lastIndexOf("/");
            relTo = slash > 1 ? relTo.substring(0, slash + 1) : "/";
            path = URIUtil.addPaths((String)relTo, (String)path);
        }
        return context.getServletContext().getRequestDispatcher(path);
    }

    public int getRemotePort() {
        return Request.getRemotePort((Request)this.getRequest());
    }

    public String getLocalName() {
        ServletChannel servletChannel = this.getServletRequestInfo().getServletChannel();
        if (servletChannel != null) {
            String localName = servletChannel.getLocalName();
            return this.formatAddrOrHost(localName);
        }
        return "";
    }

    public String getLocalAddr() {
        return Request.getLocalAddr((Request)this.getRequest());
    }

    public int getLocalPort() {
        return Request.getLocalPort((Request)this.getRequest());
    }

    public ServletContext getServletContext() {
        return this.getServletRequestInfo().getServletChannel().getServletContextApi();
    }

    public AsyncContext startAsync() throws IllegalStateException {
        if (!this.isAsyncSupported()) {
            throw new IllegalStateException("Async Not Supported");
        }
        return this.forceStartAsync();
    }

    private AsyncContext forceStartAsync() {
        ServletChannelState state = this.getServletRequestInfo().getState();
        if (this._async == null) {
            this._async = new AsyncContextState(state);
        }
        ServletContextHandler.ServletRequestInfo servletRequestInfo = this.getServletRequestInfo();
        AsyncContextEvent event = new AsyncContextEvent(this.getServletRequestInfo().getServletContext(), this._async, state, (ServletRequest)servletRequestInfo.getServletChannel().getServletContextRequest().getServletApiRequest(), (ServletResponse)servletRequestInfo.getServletChannel().getServletContextResponse().getServletApiResponse());
        state.startAsync(event);
        return this._async;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        if (!this.isAsyncSupported()) {
            throw new IllegalStateException("Async Not Supported");
        }
        ServletChannelState state = this.getServletRequestInfo().getState();
        if (this._async == null) {
            this._async = new AsyncContextState(state);
        }
        AsyncContextEvent event = new AsyncContextEvent(this.getServletRequestInfo().getServletContext(), this._async, state, servletRequest, servletResponse);
        state.startAsync(event);
        return this._async;
    }

    public HttpServletMapping getHttpServletMapping() {
        return ((ServletHandler.MappedServlet)this.getServletRequestInfo().getMatchedResource().getResource()).getServletPathMapping(this.getServletRequestInfo().getDecodedPathInContext());
    }

    public boolean isAsyncStarted() {
        return this.getServletRequestInfo().getState().isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this._asyncSupported;
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this._asyncSupported = asyncSupported;
    }

    public AsyncContext getAsyncContext() {
        ServletChannelState state = this.getServletRequestInfo().getServletChannel().getServletRequestState();
        if (this._async == null || !state.isAsyncStarted()) {
            throw new IllegalStateException(state.getStatusString());
        }
        return this._async;
    }

    public DispatcherType getDispatcherType() {
        Request request = this.getRequest();
        String dispatchType = request.getContext().getCrossContextDispatchType(request);
        return dispatchType == null ? DispatcherType.REQUEST : DispatcherType.valueOf((String)dispatchType);
    }

    public Map<String, String> getTrailerFields() {
        HttpFields trailers = this.getRequest().getTrailers();
        if (trailers == null) {
            return Map.of();
        }
        HashMap<String, String> trailersMap = new HashMap<String, String>();
        for (HttpField field : trailers) {
            String key = field.getLowerCaseName();
            trailersMap.merge(key, field.getValue(), (existing, value) -> existing + "," + value);
        }
        return trailersMap;
    }

    public String toString() {
        return "%s@%x{%s}".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this._servletContextRequest);
    }

    static class AmbiguousURI
    extends ServletApiRequest {
        private final String msg;

        protected AmbiguousURI(ServletContextRequest servletContextRequest, String msg) {
            super(servletContextRequest);
            this.msg = msg;
        }

        @Override
        public String getPathInfo() {
            throw new HttpException.IllegalArgumentException(400, this.msg);
        }

        @Override
        public String getServletPath() {
            throw new HttpException.IllegalArgumentException(400, this.msg);
        }
    }

    public static class CrossContextIncluded
    extends ServletApiRequest {
        private final ServletPathMapping _originalMapping;

        protected CrossContextIncluded(ServletContextRequest servletContextRequest) {
            super(servletContextRequest);
            Request dispatchedRequest = servletContextRequest.getWrapped();
            this._originalMapping = ServletPathMapping.from(dispatchedRequest.getAttribute("org.eclipse.jetty.dispatch.originalServletMapping"));
            MatchedResource<ServletHandler.MappedServlet> matchedResource = servletContextRequest.getMatchedResource();
            dispatchedRequest.setAttribute("jakarta.servlet.include.mapping", (Object)((ServletHandler.MappedServlet)matchedResource.getResource()).getServletPathMapping(this.getServletRequestInfo().getDecodedPathInContext()));
            dispatchedRequest.setAttribute("jakarta.servlet.include.servlet_path", (Object)matchedResource.getMatchedPath().getPathMatch());
            dispatchedRequest.setAttribute("jakarta.servlet.include.path_info", (Object)matchedResource.getMatchedPath().getPathInfo());
            dispatchedRequest.setAttribute("jakarta.servlet.include.context_path", (Object)servletContextRequest.getContext().getContextPath());
        }

        @Override
        public String getPathInfo() {
            return this._originalMapping == null ? null : this._originalMapping.getPathInfo();
        }

        @Override
        public String getContextPath() {
            return (String)this.getAttribute("org.eclipse.jetty.dispatch.originalContextPath");
        }

        @Override
        public String getQueryString() {
            return (String)this.getAttribute("org.eclipse.jetty.dispatch.originalQueryString");
        }

        @Override
        public String getServletPath() {
            return this._originalMapping == null ? null : this._originalMapping.getServletPath();
        }

        @Override
        public HttpServletMapping getHttpServletMapping() {
            return this._originalMapping;
        }

        @Override
        public String getRequestURI() {
            return (String)this.getAttribute("org.eclipse.jetty.dispatch.originalURI");
        }

        @Override
        protected void extractQueryParameters() throws BadMessageException {
            if (this._queryParameters == null) {
                String includedQueryString = (String)this.getAttribute("jakarta.servlet.include.query_string");
                String originalQueryString = this.getQueryString();
                if (StringUtil.isBlank((String)includedQueryString)) {
                    if (StringUtil.isBlank((String)originalQueryString)) {
                        this._queryParameters = ServletContextRequest.NO_PARAMS;
                    } else {
                        this._queryParameters = new Fields(true);
                        UrlEncoded.decodeTo((String)includedQueryString, (arg_0, arg_1) -> ((Fields)this._queryParameters).add(arg_0, arg_1), (Charset)this.getServletRequestInfo().getQueryEncoding());
                    }
                } else {
                    this._queryParameters = new Fields(true);
                    if (!StringUtil.isBlank((String)originalQueryString)) {
                        UrlEncoded.decodeTo((String)originalQueryString, (arg_0, arg_1) -> ((Fields)this._queryParameters).add(arg_0, arg_1), (Charset)this.getServletRequestInfo().getQueryEncoding());
                    }
                    UrlEncoded.decodeTo((String)includedQueryString, (arg_0, arg_1) -> ((Fields)this._queryParameters).add(arg_0, arg_1), (Charset)this.getServletRequestInfo().getQueryEncoding());
                }
            }
        }
    }

    public static class CrossContextForwarded
    extends ServletApiRequest {
        protected CrossContextForwarded(ServletContextRequest servletContextRequest) {
            super(servletContextRequest);
        }

        @Override
        protected void extractQueryParameters() throws BadMessageException {
            if (this._queryParameters == null) {
                String forwardQueryString = (String)this.getAttribute("jakarta.servlet.forward.query_string");
                String originalQueryString = this.getQueryString();
                if (StringUtil.isBlank((String)forwardQueryString)) {
                    if (StringUtil.isBlank((String)originalQueryString)) {
                        this._queryParameters = ServletContextRequest.NO_PARAMS;
                    } else {
                        this._queryParameters = new Fields(true);
                        UrlEncoded.decodeTo((String)forwardQueryString, (arg_0, arg_1) -> ((Fields)this._queryParameters).add(arg_0, arg_1), (Charset)this.getServletRequestInfo().getQueryEncoding());
                    }
                } else {
                    this._queryParameters = new Fields(true);
                    if (!StringUtil.isBlank((String)originalQueryString)) {
                        UrlEncoded.decodeTo((String)originalQueryString, (arg_0, arg_1) -> ((Fields)this._queryParameters).add(arg_0, arg_1), (Charset)this.getServletRequestInfo().getQueryEncoding());
                    }
                    UrlEncoded.decodeTo((String)forwardQueryString, (arg_0, arg_1) -> ((Fields)this._queryParameters).add(arg_0, arg_1), (Charset)this.getServletRequestInfo().getQueryEncoding());
                }
            }
        }
    }
}

