/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.e4.internal;

import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rap.e4.internal.Activator;
import org.eclipse.rap.e4.internal.RAPUIEventHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

public class RAPEventBroker
implements IEventBroker {
    private static final String ASYNC_EVENT = "rap.async.event";
    private Map<EventHandler, Collection<ServiceRegistration<?>>> registrations = new HashMap();
    @Inject
    Logger logger;
    @Inject
    @Optional
    UISynchronize uiSync;
    @Inject
    @Named(value="E4Application.instanceId")
    String instanceId;

    static {
        EventAdmin eventAdmin = Activator.getDefault().getEventAdmin();
        if (eventAdmin == null) {
            Bundle[] bundles;
            Bundle[] bundleArray = bundles = Activator.getDefault().getBundleContext().getBundles();
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if ("org.eclipse.equinox.event".equals(bundle.getSymbolicName())) {
                    try {
                        bundle.start(1);
                    }
                    catch (BundleException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                ++n2;
            }
        }
    }

    public boolean send(String topic, Object data) {
        Event event = this.constructEvent(topic, data, false);
        EventAdmin eventAdmin = Activator.getDefault().getEventAdmin();
        if (eventAdmin == null) {
            this.logger.error(NLS.bind((String)"No EventAdmin", (Object)event.toString()));
            return false;
        }
        eventAdmin.sendEvent(event);
        return true;
    }

    public boolean post(String topic, Object data) {
        Event event = this.constructEvent(topic, data, true);
        EventAdmin eventAdmin = Activator.getDefault().getEventAdmin();
        if (eventAdmin == null) {
            this.logger.error(NLS.bind((String)"No EventAdmin", (Object)event.toString()));
            return false;
        }
        eventAdmin.postEvent(event);
        return true;
    }

    private Event constructEvent(String topic, Object data, boolean async) {
        Event event;
        topic = RAPEventBroker.rapifyTopic(this.instanceId, topic);
        if (data instanceof Dictionary) {
            Dictionary properties = (Dictionary)data;
            if (async) {
                properties.put(ASYNC_EVENT, Boolean.TRUE);
            }
            event = new Event(topic, properties);
        } else if (data instanceof Map) {
            Map properties = (Map)data;
            if (async) {
                properties.put(ASYNC_EVENT, Boolean.TRUE);
            }
            event = new Event(topic, properties);
        } else {
            Hashtable<String, Object> d = new Hashtable<String, Object>(3);
            ((Dictionary)d).put("event.topics", topic);
            if (data != null) {
                ((Dictionary)d).put("org.eclipse.e4.data", data);
            }
            if (async) {
                ((Dictionary)d).put(ASYNC_EVENT, Boolean.TRUE);
            }
            event = new Event(topic, d);
        }
        return event;
    }

    public boolean subscribe(String topic, EventHandler eventHandler) {
        return this.subscribe(topic, null, eventHandler, false);
    }

    public boolean subscribe(String topic, String filter, EventHandler eventHandler, boolean headless) {
        topic = RAPEventBroker.rapifyTopic(this.instanceId, topic);
        BundleContext bundleContext = Activator.getDefault().getBundleContext();
        if (bundleContext == null) {
            this.logger.error(NLS.bind((String)"No EventAdmin", (Object)topic));
            return false;
        }
        String[] topics = new String[]{topic};
        Hashtable<String, Object> d = new Hashtable<String, Object>();
        ((Dictionary)d).put("event.topics", topics);
        if (filter != null) {
            ((Dictionary)d).put("event.filter", filter);
        }
        RAPUIEventHandler wrappedHandler = new RAPUIEventHandler(eventHandler, headless ? null : this.uiSync);
        ServiceRegistration registration = bundleContext.registerService(EventHandler.class.getName(), (Object)wrappedHandler, d);
        Collection<ServiceRegistration<?>> handled = this.registrations.get(eventHandler);
        if (handled == null) {
            handled = new ArrayList();
            this.registrations.put(eventHandler, handled);
        }
        handled.add(registration);
        return true;
    }

    public boolean unsubscribe(EventHandler eventHandler) {
        Collection<ServiceRegistration<?>> handled = this.registrations.remove(eventHandler);
        if (handled == null || handled.isEmpty()) {
            return false;
        }
        for (ServiceRegistration<?> r : handled) {
            r.unregister();
        }
        return true;
    }

    @PreDestroy
    void dispose() {
        ArrayList values = new ArrayList(this.registrations.values());
        this.registrations.clear();
        for (Collection collection : values) {
            for (ServiceRegistration registration : collection) {
                registration.unregister();
            }
        }
    }

    public static String rapifyTopic(String instanceId, String topic) {
        String rv = instanceId + "/" + topic;
        return rv;
    }

    public static boolean isAsyncEvent(Event event) {
        return Boolean.TRUE.equals(event.getProperty(ASYNC_EVENT));
    }
}

