/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Policy;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

class URLImageDescriptor
extends ImageDescriptor {
    private static final String FILE_PROTOCOL = "file";
    private URL url;

    URLImageDescriptor(URL url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (!(o instanceof URLImageDescriptor)) {
            return false;
        }
        return ((URLImageDescriptor)o).url.toExternalForm().equals(this.url.toExternalForm());
    }

    @Override
    public ImageData getImageData() {
        ImageData result = null;
        InputStream in = this.getStream();
        if (in != null) {
            try {
                try {
                    result = new ImageData(in);
                }
                catch (SWTException e) {
                    if (e.code != 40) {
                        throw e;
                    }
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", e2.getLocalizedMessage(), (Throwable)e2));
                    }
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", e.getLocalizedMessage(), (Throwable)e));
                }
            }
        }
        return result;
    }

    protected InputStream getStream() {
        try {
            return new BufferedInputStream(this.url.openStream());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int hashCode() {
        return this.url.toExternalForm().hashCode();
    }

    public String toString() {
        return "URLImageDescriptor(" + String.valueOf(this.url) + ")";
    }

    @Override
    public Image createImage(boolean returnMissingImageOnError, Device device) {
        String schema;
        String path = this.url.toString();
        int pos = path.indexOf(schema = "bundleentry://");
        if (pos != -1) {
            path = path.substring(pos + schema.length());
        }
        if ((pos = path.indexOf(schema = "bundleresource://")) != -1) {
            path = path.substring(pos + schema.length());
        }
        if ((pos = path.indexOf(schema = "platform:/")) != -1) {
            path = path.substring(pos + schema.length());
        }
        Image result = null;
        InputStream stream = this.getStream();
        if (stream != null) {
            try {
                result = ContextProvider.getApplicationContext().getImageFactory().createImage(device, path, stream);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", e.getMessage(), (Throwable)e));
                }
            }
        }
        if (returnMissingImageOnError) {
            try {
                result = new Image(device, DEFAULT_IMAGE_DATA);
            }
            catch (SWTException sWTException) {
                result = null;
            }
        }
        return result;
    }
}

