/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import jakarta.servlet.http.HttpServletRequest;
import org.eclipse.rap.rwt.application.EntryPoint;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointManager;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointRegistration;
import org.eclipse.rap.rwt.internal.lifecycle.IPhase;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rap.rwt.internal.lifecycle.PhaseId;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.swt.widgets.Display;

final class PrepareUIRoot
implements IPhase {
    private final ApplicationContextImpl applicationContext;

    public PrepareUIRoot(ApplicationContextImpl applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public PhaseId getPhaseId() {
        return PhaseId.PREPARE_UI_ROOT;
    }

    @Override
    public PhaseId execute(Display display) {
        PhaseId result;
        if (LifeCycleUtil.isStartup()) {
            EntryPoint entryPoint = this.createEntryPoint();
            entryPoint.createUI();
            PrepareUIRoot.processPendingMessages();
            result = PhaseId.RENDER;
        } else {
            result = PhaseId.READ_DATA;
        }
        return result;
    }

    private EntryPoint createEntryPoint() {
        EntryPointManager entryPointManager = this.applicationContext.getEntryPointManager();
        HttpServletRequest request = ContextProvider.getRequest();
        EntryPointRegistration registration = entryPointManager.getEntryPointRegistration(request);
        return registration.getFactory().create();
    }

    private static void processPendingMessages() {
        Display display = Display.getCurrent();
        if (display != null) {
            while (display.readAndDispatch()) {
            }
        }
    }
}

