/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.textsize.MeasurementUtil;
import org.eclipse.rap.rwt.internal.theme.Theme;
import org.eclipse.rap.rwt.internal.theme.ThemeManager;
import org.eclipse.rap.rwt.internal.theme.ThemeUtil;

public class StartupJson {
    static final String PROPERTY_URL = "url";
    static final String PROPERTY_STARTUP_PARAMETERS = "startupParameters";
    static final String DISPLAY_TYPE = "rwt.widgets.Display";
    static final String THEME_STORE_TYPE = "rwt.theme.ThemeStore";
    static final String METHOD_LOAD_FALLBACK_THEME = "loadFallbackTheme";
    static final String METHOD_LOAD_ACTIVE_THEME = "loadActiveTheme";

    private StartupJson() {
    }

    public static void send(HttpServletResponse response) throws IOException {
        StartupJson.setResponseHeaders(response);
        StartupJson.get().writeTo(response.getWriter());
    }

    static JsonObject get() {
        ProtocolMessageWriter writer = new ProtocolMessageWriter();
        StartupJson.appendLoadThemeDefinitions(writer);
        StartupJson.appendCreateDisplay("w1", writer);
        MeasurementUtil.appendStartupTextSizeProbe(writer);
        return writer.createMessage().toJson();
    }

    private static void setResponseHeaders(HttpServletResponse response) {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.addHeader("Cache-Control", "max-age=0, no-cache, must-revalidate, no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    private static void appendCreateDisplay(String id, ProtocolMessageWriter writer) {
        writer.appendCreate(id, DISPLAY_TYPE);
        String startupParameters = StartupJson.getStartupParameters();
        if (!startupParameters.isEmpty()) {
            writer.appendSet(id, PROPERTY_STARTUP_PARAMETERS, startupParameters);
        }
        writer.appendHead(PROPERTY_URL, JsonValue.valueOf(StartupJson.getUrl()));
    }

    private static String getStartupParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        Map parameterMap = ContextProvider.getRequest().getParameterMap();
        try {
            for (String name : parameterMap.keySet()) {
                String[] stringArray = (String[])parameterMap.get(name);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    String encName = URLEncoder.encode(name, "UTF-8");
                    String encValue = URLEncoder.encode(value, "UTF-8");
                    parameters.add(String.valueOf(encName) + "=" + encValue);
                    ++n2;
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return String.join((CharSequence)"&", parameters);
    }

    private static void appendLoadThemeDefinitions(ProtocolMessageWriter writer) {
        ThemeManager themeManager = ContextProvider.getApplicationContext().getThemeManager();
        Theme fallbackTheme = themeManager.getTheme("org.eclipse.rap.rwt.theme.Fallback");
        StartupJson.appendLoadTheme(writer, METHOD_LOAD_FALLBACK_THEME, fallbackTheme);
        String servletPath = ContextProvider.getRequest().getServletPath();
        Theme currentTheme = themeManager.getTheme(ThemeUtil.getThemeIdFor(servletPath));
        StartupJson.appendLoadTheme(writer, METHOD_LOAD_ACTIVE_THEME, currentTheme);
    }

    private static void appendLoadTheme(ProtocolMessageWriter writer, String method, Theme theme) {
        JsonObject parameters = new JsonObject().add(PROPERTY_URL, theme.getRegisteredLocation());
        writer.appendCall(THEME_STORE_TYPE, method, parameters);
    }

    private static String getUrl() {
        String servletPath = ContextProvider.getRequest().getServletPath();
        String url = "".equals(servletPath) ? "./" : servletPath.substring(1);
        return ContextProvider.getResponse().encodeURL(url);
    }
}

