/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.wst.xml.xpath2.api.DynamicContext;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.TypeError;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.ElementType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class FnInScopePrefixes
extends Function {
    private static Collection _expected_args = null;

    public FnInScopePrefixes() {
        super(new QName("in-scope-prefixes"), 1);
    }

    @Override
    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        return FnInScopePrefixes.inScopePrefixes(args, ec.getDynamicContext());
    }

    public static ResultSequence inScopePrefixes(Collection args, DynamicContext dc) throws DynamicError {
        Collection cargs = args;
        ResultSequence arg1 = (ResultSequence)cargs.iterator().next();
        if (arg1.empty()) {
            return ResultBuffer.EMPTY;
        }
        ResultBuffer rs = new ResultBuffer();
        Item anytype = arg1.item(0);
        if (!(anytype instanceof ElementType)) {
            throw new DynamicError(TypeError.invalid_type(null));
        }
        ElementType element = (ElementType)anytype;
        List prefixList = FnInScopePrefixes.lookupPrefixes(element);
        FnInScopePrefixes.createPrefixResultSet(rs, prefixList);
        return rs.getSequence();
    }

    private static void createPrefixResultSet(ResultBuffer rs, List prefixList) {
        int i = 0;
        while (i < prefixList.size()) {
            String prefix = (String)prefixList.get(i);
            rs.add(new XSString(prefix));
            ++i;
        }
    }

    private static List lookupPrefixes(ElementType element) {
        Element domElm = (Element)element.node_value();
        ArrayList<String> prefixList = new ArrayList<String>();
        Node node = domElm;
        while (node != null && node.getNodeType() != 9) {
            NamedNodeMap attrs = node.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                Node attr = attrs.item(i);
                String prefix = null;
                if (attr.getNamespaceURI() != null && attr.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/") && (prefix = attr.getNodeName().equals("xmlns") ? "" : attr.getLocalName()) != null && !prefixList.contains(prefix)) {
                    prefixList.add(prefix);
                }
                ++i;
            }
            node = node.getParentNode();
        }
        return prefixList;
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            SeqType arg = new SeqType(new ElementType(), 2);
            _expected_args.add(arg);
        }
        return _expected_args;
    }
}

