/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.properties.section;

import java.util.Iterator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.dtd.core.internal.CMBasicNode;
import org.eclipse.wst.dtd.core.internal.CMNode;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.Element;
import org.eclipse.wst.dtd.core.internal.Entity;
import org.eclipse.wst.dtd.ui.internal.DTDPropertiesMessages;
import org.eclipse.wst.dtd.ui.internal.properties.section.AbstractSection;

public class ContentModelNameSection
extends AbstractSection {
    private final String CONTENT_MODEL = DTDPropertiesMessages._UI_LABEL_CONTENT_MODEL;
    private CCombo typeCombo;
    private String[] typeComboValues = new String[]{CMNode.PCDATA};

    @Override
    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        CLabel cLabel = this.getWidgetFactory().createCLabel(composite, this.CONTENT_MODEL);
        Point p = cLabel.computeSize(-1, -1, false);
        int labelWidth = Math.max(p.x, 98);
        FormData data = new FormData(labelWidth, -1);
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        cLabel.setLayoutData((Object)data);
        this.typeCombo = this.getWidgetFactory().createCCombo(composite, 0x800008);
        data = new FormData();
        data.left = new FormAttachment((Control)cLabel, -5);
        data.right = new FormAttachment(100);
        data.top = new FormAttachment((Control)cLabel, 0, 0x1000000);
        this.typeCombo.setLayoutData((Object)data);
        this.typeCombo.addSelectionListener((SelectionListener)this);
        this.typeCombo.setItems(this.typeComboValues);
    }

    @Override
    public void refresh() {
        Object input = this.getInput();
        if (input != null && input instanceof CMBasicNode) {
            this.typeCombo.removeAll();
            this.typeCombo.add(CMNode.PCDATA);
            Iterator iterator = ((CMBasicNode)input).getDTDFile().getNodes().iterator();
            boolean isForRootContent = ((CMBasicNode)input).isRootElementContent();
            while (iterator.hasNext()) {
                DTDNode node = (DTDNode)iterator.next();
                if (!isForRootContent && node instanceof Element) {
                    this.typeCombo.add(node.getName());
                }
                if (!(node instanceof Entity) || !((Entity)node).isParameterEntity()) continue;
                this.typeCombo.add("%" + node.getName() + ";");
            }
            this.typeCombo.setText(((CMBasicNode)input).getName());
        }
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        Object input;
        if (e.widget == this.typeCombo && (input = this.getInput()) instanceof CMBasicNode) {
            CMBasicNode node = (CMBasicNode)input;
            String selected = this.typeCombo.getText();
            node.setName(selected);
        }
    }

    @Override
    public boolean shouldUseExtraSpace() {
        return false;
    }
}

