/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.beans;

import java.util.Collections;
import java.util.List;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.model.reference.IReferenceProvider;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.swing.databinding.model.ObserveCreationType;
import org.eclipse.wb.internal.swing.databinding.model.ObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.BeanSupport;
import org.eclipse.wb.internal.swing.databinding.model.generic.IGenericType;

public abstract class BeanObserveInfo
extends ObserveInfo {
    private final BeanSupport m_beanSupport;
    private final ObserveInfo m_parent;
    private List<ObserveInfo> m_properties;

    public BeanObserveInfo(BeanSupport beanSupport, ObserveInfo parent, IGenericType objectType, IReferenceProvider referenceProvider) {
        super(objectType, referenceProvider);
        this.m_beanSupport = beanSupport;
        this.m_parent = parent;
    }

    public ObserveType getType() {
        return ObserveType.BEANS;
    }

    @Override
    public ObserveCreationType getCreationType() {
        return ObserveCreationType.AutoBinding;
    }

    public final IObserveInfo getParent() {
        return this.m_parent;
    }

    public final List<IObserveInfo> getChildren(IObserveInfo.ChildrenContext context) {
        if (context == IObserveInfo.ChildrenContext.ChildrenForPropertiesTable) {
            if (this.m_properties == null) {
                this.m_properties = this.m_beanSupport.createProperties(this, this.getObjectType());
            }
            return CoreUtils.cast(this.m_properties);
        }
        return Collections.emptyList();
    }

    protected final void setProperties(List<ObserveInfo> properties) {
        this.m_properties = properties;
    }
}

