/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.ConnectorKind;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.internal.operations.RedefinableElementOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorOperations
extends RedefinableElementOperations {
    protected ConnectorOperations() {
    }

    public static boolean validateTypes(Connector connector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Association connectorType = connector.getType();
        if (connectorType != null) {
            Iterator ends = connector.getEnds().iterator();
            Iterator memberEnds = connectorType.getMemberEnds().iterator();
            while (ends.hasNext() && memberEnds.hasNext()) {
                ConnectableElement role = ((ConnectorEnd)ends.next()).getRole();
                Type type = role == null ? null : role.getType();
                Type memberEndType = ((Property)memberEnds.next()).getType();
                if (!(type == null ? memberEndType != null : !type.conformsTo(memberEndType))) continue;
                result = false;
                break;
            }
            if (ends.hasNext() || memberEnds.hasNext()) {
                result = false;
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 148, UMLPlugin.INSTANCE.getString("_UI_Connector_Types_diagnostic", ConnectorOperations.getMessageSubstitutions(context, (Object)connector)), new Object[]{connector}));
        }
        return result;
    }

    public static ConnectorKind getKind(Connector connector) {
        for (ConnectorEnd end : connector.getEnds()) {
            ConnectableElement role = end.getRole();
            if (!(role instanceof Port) || end.getPartWithPort() != null || ((Port)role).isBehavior()) continue;
            return ConnectorKind.DELEGATION_LITERAL;
        }
        return ConnectorKind.ASSEMBLY_LITERAL;
    }

    public static boolean validateRoles(Connector connector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EObject eContainer = connector.eContainer();
        if (eContainer instanceof StructuredClassifier) {
            EList<ConnectableElement> allRoles = ((StructuredClassifier)eContainer).allRoles();
            for (ConnectorEnd e : connector.getEnds()) {
                ConnectableElement role = e.getRole();
                if (role == null || allRoles.contains((Object)role) || role instanceof Port && allRoles.contains((Object)e.getPartWithPort())) continue;
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 149, UMLPlugin.INSTANCE.getString("_UI_Connector_Roles_diagnostic", ConnectorOperations.getMessageSubstitutions(context, (Object)connector)), new Object[]{connector}));
                }
                return false;
            }
        }
        return true;
    }
}

