/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.view.ui.internal.tabs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.terminal.control.CommandInputFieldWithHistory;
import org.eclipse.terminal.control.ICommandInputField;
import org.eclipse.terminal.control.ITerminalViewControl;
import org.eclipse.terminal.view.ui.internal.tabs.TabFolderManager;
import org.eclipse.ui.services.IDisposable;

public class TabCommandFieldHandler
implements IDisposable,
IAdaptable {
    private final TabFolderManager tabFolderManager;
    private final CTabItem item;
    private CommandInputFieldWithHistory field;
    private String history;

    public TabCommandFieldHandler(TabFolderManager tabFolderManager, CTabItem item) {
        Assert.isNotNull((Object)((Object)tabFolderManager));
        this.tabFolderManager = tabFolderManager;
        Assert.isNotNull((Object)item);
        this.item = item;
    }

    public void dispose() {
        this.field = null;
        this.history = null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (TabFolderManager.class.equals(adapter)) {
            return adapter.cast((Object)this.tabFolderManager);
        }
        if (CTabItem.class.equals(adapter)) {
            return adapter.cast(this.item);
        }
        return null;
    }

    public boolean hasCommandInputField() {
        return this.field != null;
    }

    public void setCommandInputField(boolean on) {
        if (this.field != null) {
            this.history = this.field.getHistory();
            this.field = null;
        }
        if (on) {
            this.field = new CommandInputFieldWithHistory(100);
            this.field.setHistory(this.history);
        }
        Assert.isTrue((!this.item.isDisposed() ? 1 : 0) != 0);
        ITerminalViewControl terminal = (ITerminalViewControl)this.item.getData();
        if (terminal != null) {
            terminal.setCommandInputField((ICommandInputField)this.field);
        }
    }
}

