/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.layout.provider;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.AbstractLayoutEditPartProvider;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeContainer2EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeContainerEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeContainerViewNodeContainerCompartment2EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeContainerViewNodeContainerCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.AbstractLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.ExclusionLayoutHint;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.LayoutService;
import org.eclipse.sirius.ecore.extender.business.internal.accessor.ecore.EMFUtil;

public class LayoutChildrenProvider
extends AbstractLayoutProvider {
    private Optional<AbstractLayoutEditPartProvider> baseLayoutProviderOpt;

    public LayoutChildrenProvider() {
        this.baseLayoutProviderOpt = Optional.empty();
    }

    public LayoutChildrenProvider(AbstractLayoutEditPartProvider baseLayoutProvider) {
        this.baseLayoutProviderOpt = Optional.of(baseLayoutProvider);
    }

    public Command layoutEditParts(List selectionRaw, IAdaptable layoutHint) {
        List selection = selectionRaw;
        List<GraphicalEditPart> selectedEditParts = selection.stream().filter(GraphicalEditPart.class::isInstance).map(GraphicalEditPart.class::cast).toList();
        List directChildren = selectedEditParts.stream().flatMap(selectedEditPart -> this.getContent((GraphicalEditPart)selectedEditPart).stream()).toList();
        List directChildrenEdges = directChildren.stream().flatMap(this::getConnectionsStream).distinct().toList();
        List<GraphicalEditPart> excludeEditPart = directChildren.stream().flatMap(this::getRecursivelyChildrenStream).distinct().filter(editPart -> !directChildren.contains(editPart)).filter(editPart -> !directChildrenEdges.contains(editPart)).toList();
        ExclusionLayoutHint newLayoutHint = new ExclusionLayoutHint(excludeEditPart, layoutHint);
        return this.baseLayoutProviderOpt.or(this.getDefaultProvider(directChildren)).map(baseLayoutProvider -> baseLayoutProvider.layoutEditParts(directChildren, newLayoutHint)).orElse((Command)UnexecutableCommand.INSTANCE);
    }

    public boolean isAvailableFor(List<? extends EditPart> selection) {
        List<GraphicalEditPart> selectedEditParts = selection.stream().filter(GraphicalEditPart.class::isInstance).map(GraphicalEditPart.class::cast).toList();
        List directChildren = selectedEditParts.stream().flatMap(selectedEditPart -> this.getContent((GraphicalEditPart)selectedEditPart).stream()).toList();
        return !directChildren.isEmpty() && this.baseLayoutProviderOpt.or(this.getDefaultProvider(directChildren)).isPresent();
    }

    private Supplier<? extends Optional<? extends AbstractLayoutEditPartProvider>> getDefaultProvider(List<? extends GraphicalEditPart> editParts) {
        return () -> editParts.stream().filter(IGraphicalEditPart.class::isInstance).map(IGraphicalEditPart.class::cast).findFirst().map(first -> LayoutService.getProvider(first).getLayoutNodeProvider((IGraphicalEditPart)first));
    }

    private Stream<? extends GraphicalEditPart> getConnectionsStream(GraphicalEditPart editPart) {
        List source = editPart.getSourceConnections();
        List target = editPart.getTargetConnections();
        return Stream.concat(source.stream(), target.stream());
    }

    private Stream<? extends GraphicalEditPart> getRecursivelyChildrenStream(GraphicalEditPart editPart) {
        return EMFUtil.getTreeStream((Object)editPart, parent -> {
            Stream children = parent.getChildren().stream();
            Stream<? extends GraphicalEditPart> connections = this.getConnectionsStream((GraphicalEditPart)parent);
            return Stream.concat(children, connections).toList();
        });
    }

    private List<? extends GraphicalEditPart> getContent(GraphicalEditPart editPart) {
        if (editPart instanceof DDiagramEditPart) {
            DDiagramEditPart diagram = (DDiagramEditPart)editPart;
            return diagram.getChildren();
        }
        if (editPart instanceof DNodeContainerEditPart) {
            DNodeContainerEditPart container = (DNodeContainerEditPart)editPart;
            Optional<DNodeContainerViewNodeContainerCompartmentEditPart> compartmentOpt = container.getChildren().stream().filter(DNodeContainerViewNodeContainerCompartmentEditPart.class::isInstance).map(DNodeContainerViewNodeContainerCompartmentEditPart.class::cast).findAny();
            return compartmentOpt.map(compartment -> compartment.getChildren()).orElse(Collections.emptyList());
        }
        if (editPart instanceof DNodeContainer2EditPart) {
            DNodeContainer2EditPart container2 = (DNodeContainer2EditPart)editPart;
            Optional<DNodeContainerViewNodeContainerCompartment2EditPart> compartmentOpt = container2.getChildren().stream().filter(DNodeContainerViewNodeContainerCompartment2EditPart.class::isInstance).map(DNodeContainerViewNodeContainerCompartment2EditPart.class::cast).findAny();
            return compartmentOpt.map(compartment -> compartment.getChildren()).orElse(Collections.emptyList());
        }
        return Collections.emptyList();
    }
}

