/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.externalization;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.ITransferList;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.UncategorizedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.externalization.SaxTaskListElementBuilder;
import org.xml.sax.Attributes;

public class SaxCategoryBuilder
extends SaxTaskListElementBuilder<AbstractTaskCategory> {
    private AbstractTaskCategory category;
    private final ITransferList taskList;

    public SaxCategoryBuilder(ITransferList taskList) {
        this.taskList = taskList;
    }

    @Override
    public void beginItem(Attributes elementAttributes) {
        try {
            String name = elementAttributes.getValue("Name");
            if (StringUtils.isNotEmpty((CharSequence)name)) {
                String handle = elementAttributes.getValue("Handle");
                if (StringUtils.isEmpty((CharSequence)handle)) {
                    handle = name;
                }
                this.category = this.taskList.getContainerForHandle(handle);
                if (this.category == null) {
                    this.category = new TaskCategory(handle, name);
                } else if (!UncategorizedTaskContainer.HANDLE.equals(handle)) {
                    this.addError((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", String.format("Category with handle \"%s\" already exists in task list", handle)));
                }
            } else {
                this.addError((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Category is missing name attribute"));
            }
        }
        catch (Exception e) {
            this.addError((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", String.format("Exception reading category: %s", e.getMessage()), (Throwable)e));
        }
    }

    @Override
    protected void applyAttribute(String attributeKey, String attributeValue) {
    }

    @Override
    public AbstractTaskCategory getItem() {
        return this.category;
    }

    @Override
    public void addToTaskList(ITransferList taskList) {
        if (this.category instanceof TaskCategory) {
            taskList.addCategory((TaskCategory)this.category);
        }
    }
}

