/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.threads;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.snapshot.extension.IClassSpecificNameResolver;
import org.eclipse.mat.snapshot.extension.Subjects;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.MessageUtil;

@Subjects(value={"<method>", "<stack frame>"})
public class StackFrameResolver
implements IClassSpecificNameResolver {
    @Override
    public String resolve(IObject object) throws SnapshotException {
        String methodName = (String)object.resolveValue("methodName");
        String fileName = (String)object.resolveValue("fileName");
        if (fileName == null) {
            fileName = (String)object.getClazz().resolveValue("fileName");
        }
        Integer lineNumber = (Integer)object.resolveValue("lineNumber");
        Integer compLevel = (Integer)object.resolveValue("compilationLevel");
        Boolean nativ = (Boolean)object.resolveValue("native");
        String ret = fileName != null && lineNumber != null && lineNumber > 0 ? (methodName == null ? (Boolean.TRUE.equals(nativ) ? MessageUtil.format((String)Messages.StackFrameResolver_file_line_native, (Object[])new Object[]{fileName, lineNumber}) : (compLevel != null && compLevel > 0 ? MessageUtil.format((String)Messages.StackFrameResolver_file_line_compiled, (Object[])new Object[]{fileName, lineNumber}) : MessageUtil.format((String)Messages.StackFrameResolver_file_line, (Object[])new Object[]{fileName, lineNumber}))) : (Boolean.TRUE.equals(nativ) ? MessageUtil.format((String)Messages.StackFrameResolver_method_file_line_native, (Object[])new Object[]{methodName, fileName, lineNumber}) : (compLevel != null && compLevel > 0 ? MessageUtil.format((String)Messages.StackFrameResolver_method_file_line_compiled, (Object[])new Object[]{methodName, fileName, lineNumber}) : MessageUtil.format((String)Messages.StackFrameResolver_method_file_line, (Object[])new Object[]{methodName, fileName, lineNumber})))) : (fileName != null ? (methodName == null ? (Boolean.TRUE.equals(nativ) ? MessageUtil.format((String)Messages.StackFrameResolver_file_native, (Object[])new Object[]{fileName}) : (compLevel != null && compLevel > 0 ? MessageUtil.format((String)Messages.StackFrameResolver_file_compiled, (Object[])new Object[]{fileName}) : MessageUtil.format((String)Messages.StackFrameResolver_file, (Object[])new Object[]{fileName}))) : (Boolean.TRUE.equals(nativ) ? MessageUtil.format((String)Messages.StackFrameResolver_method_file_native, (Object[])new Object[]{methodName, fileName}) : (compLevel != null && compLevel > 0 ? MessageUtil.format((String)Messages.StackFrameResolver_method_file_compiled, (Object[])new Object[]{methodName, fileName}) : MessageUtil.format((String)Messages.StackFrameResolver_method_file, (Object[])new Object[]{methodName, fileName})))) : (methodName != null ? MessageUtil.format((String)Messages.StackFrameResolver_method, (Object[])new Object[]{methodName}) : ""));
        return ret;
    }
}

