/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryAttribute;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;

final class BinaryField
extends BinaryAttribute
implements JavaResourceField {
    BinaryField(JavaResourceType parent, IField field) {
        this(parent, new FieldAdapter(field));
    }

    private BinaryField(JavaResourceType parent, FieldAdapter adapter) {
        super(parent, adapter);
    }

    @Override
    public JavaResourceAnnotatedElement.AstNodeType getAstNodeType() {
        return JavaResourceAnnotatedElement.AstNodeType.FIELD;
    }

    @Override
    public void synchronizeWith(FieldDeclaration fieldDeclaration, VariableDeclarationFragment variableDeclaration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resolveTypes(FieldDeclaration fieldDeclaration, VariableDeclarationFragment variableDeclaration) {
        throw new UnsupportedOperationException();
    }

    static class FieldAdapter
    implements BinaryAttribute.AttributeAdapter {
        private final IField field;
        private final ITypeBinding typeBinding;

        FieldAdapter(IField field) {
            this.field = field;
            this.typeBinding = this.buildTypeBinding();
        }

        protected ITypeBinding buildTypeBinding() {
            IVariableBinding binding = (IVariableBinding)ASTTools.createBinding((IMember)this.field);
            return binding == null ? null : binding.getType();
        }

        public IField getElement() {
            return this.field;
        }

        @Override
        public IAnnotation[] getAnnotations() throws JavaModelException {
            return this.field.getAnnotations();
        }

        @Override
        public String getAttributeName() {
            return this.field.getElementName();
        }

        @Override
        public ITypeBinding getTypeBinding() {
            return this.typeBinding;
        }
    }
}

