/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.operations;

import javafx.scene.Node;
import javafx.scene.transform.Transform;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef.geometry.planar.AffineTransform;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.ITransformableContentPart;

public class TransformContentOperation
extends AbstractOperation
implements ITransactionalOperation {
    private final ITransformableContentPart<? extends Node> transformableContentPart;
    private AffineTransform finalTransform;
    private AffineTransform initialTransform;

    public TransformContentOperation(ITransformableContentPart<? extends Node> transformableContentPart, AffineTransform finalTransform) {
        super("Transform Content");
        this.transformableContentPart = transformableContentPart;
        this.initialTransform = FX2Geometry.toAffineTransform((Transform)transformableContentPart.getContentTransform());
        this.finalTransform = finalTransform;
    }

    private void applyTransform(AffineTransform transform) {
        if (!this.transformableContentPart.getContentTransform().equals(this.finalTransform)) {
            this.transformableContentPart.setContentTransform(Geometry2FX.toFXAffine((AffineTransform)transform));
        }
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.applyTransform(this.finalTransform);
        return Status.OK_STATUS;
    }

    @Override
    public boolean isContentRelevant() {
        return true;
    }

    @Override
    public boolean isNoOp() {
        return this.initialTransform.equals((Object)this.finalTransform);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public void setFinalDelta(AffineTransform transform) {
        this.finalTransform = transform;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.applyTransform(this.initialTransform);
        return Status.OK_STATUS;
    }
}

